<!doctype html>

<html>

<head>
	<?php
	$langDir = __DIR__ . '/include/lang/';
    $langFiles = scandir($langDir);
    $languages = [];
    foreach ($langFiles as $file) {
	    if (preg_match('/^([a-z]{2})\.php$/', $file, $matches)) {
	        $code = $matches[1];
	        $filePath = $langDir . $file;
	        $content = file_get_contents($filePath);

	        // Extraire le nom de la langue avec une expression régulière
	        if (preg_match('/define\(\s*\'LANG_VALID\'\s*,\s*true\s*\)/', $content) && preg_match('/\$lang_name\s*=\s*"([^"]+)"/', $content, $nameMatches)) {
	            $languages[$code] = $nameMatches[1];
	        }
	    }
	}
	$defaultLang = 'fr';
	if (isset($_GET['lang']) && preg_match('/^[a-z]{2}$/', $_GET['lang']) && array_key_exists($_GET['lang'], $languages)) {
	    $selectedLang = $_GET['lang'];
	    $_SESSION['lang'] = $selectedLang; // Mettre à jour la session
	} elseif (isset($_SESSION['lang']) && preg_match('/^[a-z]{2}$/', $_SESSION['lang']) && array_key_exists($_SESSION['lang'], $languages)) {
	    $selectedLang = $_SESSION['lang'];
	} else {
	    $selectedLang = $defaultLang;
	}
	$_SESSION['lang'] = $selectedLang;
	if(!isset($_SESSION['lang'])) {
		require_once('include/lang/fr.php');
	}
	else {
		require_once('include/lang/'.$_SESSION['lang'].'.php');
	}
	?>
	<meta charset="utf-8" />
	<title><?php echo INSTAL2; ?> - InfodocLog</title>
	<link rel="stylesheet" type="text/css" href="css/idl_solo.css" />
	<link rel="stylesheet" type="text/css" href="css/idl_solo_resp.css" />
	<link rel="stylesheet" href="include/fontawesome/css/all.css">
	<link rel="apple-touch-icon" sizes="180x180" href="apple-touch-icon.png">
	<link rel="icon" type="image/png" sizes="32x32" href="favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="16x16" href="favicon-16x16.png">
	<script>
        function changeLanguage(lang) {
            window.location.href = '?lang=' + lang;
        }
    </script>
	<script type='text/javascript'>
	function surligne(champ, erreur) {
		if(erreur)
			champ.style.backgroundColor = "#fba";
		else
			champ.style.backgroundColor = "";
	}
	function verifPseudo(champ) {
		if(champ.value.length < 2 || champ.value.length > 40) {
			surligne(champ, true);
			return false;	
		}
		else {
			surligne(champ, false);
			return true;
		}
	}
	function verifMdp(champ) {
		if(champ.value.length < 8 || champ.value.length > 30)
		{
			surligne(champ, true);
			return false;	
		}
		else {
			surligne(champ, false);
			return true;
		}
	}
	function verifForm(f) {
		const ALERT1 = "<?php echo ALERT1; ?>";
		var pseudoOk = verifPseudo(f.login);
		var mdpOk = verifMdp(f.mdp);
		if(pseudoOk && mdpOk)
			return true;
		else {
			alert(ALERT1);
			return false;	
		}
	}
	</script>
</head>

<body>
	
	<?php $page_header = 'index'; ?>
	<?php include('include/header.php'); ?>
	
	<section>		
		<div class="center">
			<?php
			if(phpversion()<7.4&&phpversion()>=8.3) {
				echo '<p class="signal" style="text-align:center;">'.PHPVERS.'</p>';
			}
			?>
		<form method="post" action="db/install_tables.php" class="padd2" onsubmit="return verifForm(this)">
		<table id="install">
			<tr><td colspan="2"><?php echo INSTAINSTRUCT; ?>
			</td></tr>
			<tr><td><?php echo SERVER; ?></td><td><input class="inptxt" type="text" name="server" maxlength="30" value="127.0.0.1" /></td></tr>
			<tr><td><?php echo MYSQLUSER; ?></td><td><input class="inptxt" type="text" name="user" value="root" /></td></tr>
			<tr><td><?php echo PW2; ?></td><td><input class="inptxt" type="password" name="pwd" value="" /><i class="fa-solid fa-eye" onclick="showPass(this)" style="margin-left: -26px; cursor: pointer;"></i></td></tr>
			<tr><td><?php echo BDDN; ?></td><td><input class="inptxt" type="text" name="base" maxlength="30" value="idlog" /></td></tr>
			<tr><td><?php echo PREFIXN; ?></td><td><input class="inptxt" type="text" name="prefix" maxlength="10" value="idlog" /></td></tr>
			<tr><td colspan="2"><h1><?php echo ADMINN; ?></h1></td></tr>
			<tr><td><?php echo IDENT3; ?></td><td><input class="inptxt" type="text" id="login" name="login" maxlength="40" value="" onblur="verifPseudo(this)" /></td></tr>
			<tr><td><?php echo PW2; ?><br><?php echo PWNBCARAC; ?></td><td><input class="inptxt" type="password" name="mdp" maxlength="30" value=""  onblur="verifMdp(this)" /><i class="fa-solid fa-eye" onclick="showPass(this)" style="margin-left: -26px; cursor: pointer;"></i></td></tr>
			<tr><td colspan="2" class="valid"><input class="bouton inptxt boutdb" type="submit" value="<?php echo VALID; ?>" /></td></tr>
		</table>
		<script language="Javascript">
			function showPass(element) {
			    var passwordField = element.previousElementSibling;
			    var eyeIcon = element;
			    if (passwordField.type === "password") {
			      passwordField.type = "text";
			      eyeIcon.classList.remove("fa-eye");
			      eyeIcon.classList.add("fa-eye-slash");
			    } else {
			      passwordField.type = "password";
			      eyeIcon.classList.remove("fa-eye-slash");
			      eyeIcon.classList.add("fa-eye");
			    }
			  }
		</script>
		</form>
		</div>
		
	</section>
</body>
</html>
