<?php
$encoding = (mb_detect_encoding($content, ['UTF-8'], true) !== 'UTF-8') ? 1 : 0;

$id = 1;
$cdata5 = $cdata6 = $cdata7 = $cdata8 = 0;

if (!$xmlEleves) {
    echo '<p>' . PBFILE1 . ' <a href="../database.php">' . BACK . '</a>.</p>';
    return;
}

// Gestion des structures
foreach ($xmlEleves->DONNEES->STRUCTURES->STRUCTURES_ELEVE as $structure_eleve) {
    $eleve_strucid = (string) $structure_eleve['ELEVE_ID'];
    $code_structure = isset($structure_eleve->STRUCTURE->CODE_STRUCTURE) 
        ? mysqli_real_escape_string($bdd, (string)$structure_eleve->STRUCTURE->CODE_STRUCTURE) 
        : null;
    $structures[$eleve_strucid] = $code_structure;
}

if ($xmlResponsables) {
    $personnes = [];
    if (isset($xmlResponsables->DONNEES->PERSONNES->PERSONNE)) {
        foreach ($xmlResponsables->DONNEES->PERSONNES->PERSONNE as $personne) {
            // Ici PERSONNE_ID est un attribut
            $pid = trim((string) $personne['PERSONNE_ID']);
            if ($pid === '') continue;

            $personnes[$pid] = [
                'nom'        => trim((string) $personne->NOM_DE_FAMILLE),
                'prenom'     => trim((string) $personne->PRENOM),
                'adresse_id' => trim((string) $personne->ADRESSE_ID)
            ];
        }
    }

    $adresses = [];
    if (isset($xmlResponsables->DONNEES->ADRESSES->ADRESSE)) {
        foreach ($xmlResponsables->DONNEES->ADRESSES->ADRESSE as $adresse) {
            $aid = trim((string) $adresse['ADRESSE_ID']); // attribut
            if ($aid === '') continue;

            $adresses[$aid] = [
                'add1'    => trim((string) $adresse->LIGNE3_ADRESSE),
                'add2'    => trim((string) $adresse->LIGNE4_ADRESSE),
                'cpostal' => trim((string) $adresse->CODE_POSTAL),
                'ville'   => trim((string) $adresse->LIBELLE_POSTAL)
            ];
        }
    }

    $responsables = [];
    if (isset($xmlResponsables->DONNEES->RESPONSABLES->RESPONSABLE_ELEVE)) {
        foreach ($xmlResponsables->DONNEES->RESPONSABLES->RESPONSABLE_ELEVE as $resp) {
            $eid = trim((string) $resp->ELEVE_ID);      // Élément enfant
            $pid = trim((string) $resp->PERSONNE_ID);   // Élément enfant

            if ($eid === '' || $pid === '') continue;

            if ((string)$resp->NIVEAU_RESPONSABILITE === "1") {
                $responsables[$eid] = $pid;
            }
        }
    }
}

// Liste des élèves
$eleves = isset($xmlEleves->DONNEES->ELEVES) ? $xmlEleves->DONNEES->ELEVES : $xmlEleves->ELEVES;

foreach ($eleves->ELEVE as $eleve) {
    include('proc/database_datainput_check_xml.php');

    // Préparation des variables
    $eleve_strucid = (string) $eleve['ELEVE_ID'];
    $eleve_id = (string) $eleve['ELEVE_ID'];
    $att0 = @mysqli_real_escape_string($bdd, $eleve->NOM_DE_FAMILLE);
    $att1 = @mysqli_real_escape_string($bdd, $eleve->PRENOM);
    $att2 = isset($structures[$eleve_strucid]) ? $structures[$eleve_strucid] : null;

    $att_resp_nom = '';
    $att_add1 = '';
    $att_add2 = '';
    $att_cpostal = '';
    $att_ville = '';

    if (!empty($_POST['input_adresse_xml'])) {
        $pid = $responsables[$eleve_id];
        if (isset($personnes[$pid])) {
            $nom_resp    = $personnes[$pid]['nom'];
            $prenom_resp = $personnes[$pid]['prenom'];

            if ($nom_resp || $prenom_resp) {
                $att_resp_nom = mysqli_real_escape_string($bdd, trim($nom_resp.' '.$prenom_resp));
            }

            $aid = $personnes[$pid]['adresse_id'] ?? null;
            if ($aid && isset($adresses[$aid])) {
                $att_add1    = $adresses[$aid]['add1']    !== '' ? mysqli_real_escape_string($bdd, $adresses[$aid]['add1'])    : null;
                $att_add2    = $adresses[$aid]['add2']    !== '' ? mysqli_real_escape_string($bdd, $adresses[$aid]['add2'])    : null;
                $att_cpostal = $adresses[$aid]['cpostal'] !== '' ? mysqli_real_escape_string($bdd, $adresses[$aid]['cpostal']) : null;
                $att_ville   = $adresses[$aid]['ville']   !== '' ? mysqli_real_escape_string($bdd, $adresses[$aid]['ville'])   : null;
            }
        }
    }

    if ($att2 === null && isset($eleve->CODE_STRUCTURE)) {
        $att2 = mysqli_real_escape_string($bdd, $eleve->CODE_STRUCTURE);
    }

    $att_code = isset($att_code) ? $att_code : '';
    $att_ident = isset($att_ident) ? $att_ident : '';
    $att_mail = isset($att_mail) ? $att_mail : '';
    $att_mdp = isset($att_mdp) ? $att_mdp : '';
    $att_resp_nom = isset($att_resp_nom) ? $att_resp_nom : '';
    $att_add1 = isset($att_add1) ? $att_add1 : '';
    $att_add2 = isset($att_add2) ? $att_add2 : '';
    $att_cpostal = isset($att_cpostal) ? $att_cpostal : '';
    $att_ville = isset($att_ville) ? $att_ville : '';

    if (
        mysqli_num_rows(mysqli_query($bdd, "SELECT * FROM {$prefix}_user WHERE login = '$att_code'")) > 0
        || $att_code == 'reserver'
    ) {
        $att_code = '';
    }

    if (
        mysqli_num_rows(mysqli_query($bdd, "SELECT * FROM {$prefix}_user WHERE login = '$att_ident'")) > 0
        || $att_ident == 'reserver'
    ) {
        $att_ident = '';
    }

    // Date de naissance
    $att3 = @mysqli_real_escape_string($bdd, $eleve->DATE_NAISS);
    $jour = substr($att3, 0, 2);
    $mois = substr($att3, 3, 2);
    $annee = substr($att3, 6, 4);

    // Sexe
    $att4 = @mysqli_real_escape_string($bdd, $eleve->CODE_SEXE);
    if ($att4 == "2") {
        $att4 = "F";
    } elseif ($att4 == "1") {
        $att4 = "M";
    }

    // Mot de passe
    if (empty($att_mdp)) {
        $att_mdp = @mb_strtolower(substr(strToNoAccent($att1), 0, 1), 'UTF-8') . $jour . $mois . $annee;
    }

    do {
        $sel = bin2hex(random_bytes(16));
    } while ($sel === '0');

    $mdp_avec_sel = $att_mdp . $sel;
    $hashed_password = hash('sha256', $mdp_avec_sel);

    // Insertion si la division est définie
    if ($att2 !== null) {
        mysqli_query($bdd,
            "INSERT INTO {$prefix}_elevesmaj (
                nom, prenom, division, naissance, sexe, code, mdp, sel, mail, id_perso, resp_nom, add1, add2, cpostal, ville, categ
            ) VALUES (
                '$att0', '$att1', '$att2', '$annee-$mois-$jour', '$att4',
                '$att_code', '$hashed_password', '$sel', '$att_mail', '$att_ident', '$att_resp_nom', '$att_add1', '$att_add2', '$att_cpostal', '$att_ville', '1'
            )"
        );
        $id++;
    }
}
?>
