<?php session_start(); ?>
<!doctype html>
<?php 
require_once('config.php');
@include('db/idl_multi.php');
$langDir = __DIR__ . '/include/lang/';
$langFiles = scandir($langDir);
$languages = [];
foreach ($langFiles as $file) {
    if (preg_match('/^([a-z]{2})\.php$/', $file, $matches)) {
        $code = $matches[1];
        $filePath = $langDir . $file;
        $content = file_get_contents($filePath);

        // Extraire le nom de la langue avec une expression régulière
        if (preg_match('/define\(\s*\'LANG_VALID\'\s*,\s*true\s*\)/', $content) && preg_match('/\$lang_name\s*=\s*"([^"]+)"/', $content, $nameMatches)) {
            $languages[$code] = $nameMatches[1];
        }
    }
}
$defaultLang = 'fr';
// Vérifier si une langue a été passée dans l'URL
if (isset($_SESSION['lang']) && preg_match('/^[a-z]{2}$/', $_SESSION['lang']) && array_key_exists($_SESSION['lang'], $languages)) {
    $selectedLang = $_SESSION['lang'];
} else {
    $selectedLang = $defaultLang;
}
$_SESSION['lang'] = $selectedLang;
if(@$multi=="ON") {
	include('db/idl_multi.php');
	require_once(BASE_PATH . '/db/idl_connect.php');
}
else {
	require_once(BASE_PATH . '/db/idl_connect.php');
}
	$reserv_could=mysqli_fetch_assoc(mysqli_query($bdd,"SELECT valeur FROM ".$prefix."_parametres WHERE param_nom = 'freq_reseleve'"));
	$_SESSION['reserv_could'] = $reserv_could['valeur'];
	if($_SESSION['reserv_could']>0&&isset($_SESSION['userres_droits'])) {
	if ($_SESSION['userres_droits']!=1) {
		echo '<p class="noaccess">'.NOMODULE.'<br><a href="index.php">'.ACCUEIL.'</a></p>';
	}
	else {?>
<html>
<head>

	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?php echo RESA3.' '.$_SESSION['lieu_genre2'].$_SESSION['lieu_nom']; ?> - InfodocLog</title>
	<link rel="stylesheet" href="css/jquery-ui.css">
	<link rel="stylesheet" type="text/css" href="css/idl_solo.css" />
	<link rel="stylesheet" type="text/css" href="css/idl_solo_resp.css" />
	<link rel="stylesheet" type="text/css" href="css/idl_print.css" media="print" />
	<link rel="stylesheet" href="include/fontawesome/css/all.css">
	<link rel="apple-touch-icon" sizes="180x180" href="apple-touch-icon.png">
	<link rel="icon" type="image/png" sizes="32x32" href="favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="16x16" href="favicon-16x16.png">
	<script type="text/javascript" src="js/jquery-3.7.1.js"></script>
	<script type="text/javascript" src="js/jquery-ui.js"></script>
	<script type="text/javascript" src="js/jquery.tablesorter.min.js"></script>
	<script type="text/javascript" src="js/jquery.tablesorter.widgets.min.js"></script>
	<script type="text/javascript" src="js/jquery.tablesorter.pager.min.js"></script>
	<script language="javascript">
		function toggleDiv(divid){
			var element = document.getElementById(divid);
		    if (element.style.display === 'none') {
		        element.style.display = 'block';
		    } else {
		        element.style.display = 'none';
		    }
		}
	</script>
	
</head>

<body onLoad="document.forms['inscript'].elements['eleve'].focus()">
	
	<?php 
	$seqsvisu = mysqli_fetch_assoc(mysqli_query($bdd,"SELECT valeur FROM ".$prefix."_parametres WHERE param_nom = 'freq_res_seqsvisu'"));
	$onlycode_check = mysqli_query($bdd,"SELECT valeur FROM ".$prefix."_parametres WHERE param_nom = 'freq_codeonly'");
	$onlycode_check_info = mysqli_fetch_assoc($onlycode_check);
	$resavisu = mysqli_fetch_assoc(mysqli_query($bdd,"SELECT valeur FROM ".$prefix."_parametres WHERE param_nom = 'freq_resvisuedt'"));
	$colorsys_info = mysqli_fetch_assoc(mysqli_query($bdd,"SELECT valeur FROM ".$prefix."_parametres WHERE param_nom = 'edt_coloration'"));
	$colortex_info = mysqli_fetch_assoc(mysqli_query($bdd,"SELECT valeur FROM ".$prefix."_parametres WHERE param_nom = 'edt_color_text'"));
	$nivs_info = mysqli_fetch_assoc(mysqli_query($bdd,"SELECT valeur FROM ".$prefix."_parametres WHERE param_nom = 'freq_statsniv'"));	
	$nodiv = mysqli_fetch_assoc(mysqli_query($bdd,"SELECT valeur FROM ".$prefix."_parametres WHERE param_nom = 'freq_reseleve_nodiv'"));

	if($seqsvisu['valeur']=='1'&&@$_GET['page']=='evals') {
		$page_header = 'evals'; 
		include('include/header.php'); 
		include('contenu/reserver_evals.php');
	}
	else {
		$page_header = 'freqr'; 
		include('include/header.php'); 
		include('contenu/reserver_freq.php');
	}
	?>
<footer id="foot_freq">
<?php include('include/footer.php'); ?>
</footer>

</body>

</html>
<?php
}	
	
}
else {
	echo '<link rel="stylesheet" type="text/css" href="css/idl_solo.css" />';
	include('include/noaccess.php');
	echo '<br><a href="index.php">'.ACCUEIL.'</a></p>';
}
mysqli_close($bdd);
?>