<?php
function is_utf8($str) {
    return mb_detect_encoding($str, 'UTF-8', true) !== false;
}
function corriger_caracteres($str) {
    $remplacements = [
        // Minuscules accentuées
        'Ã©' => 'é',
        'Ã¨' => 'è',
        'Ã¨' => 'è',
        'Ãª' => 'ê',
        'Ã«' => 'ë',
        'Ã ' => 'à',
        'Ã ' => 'à',
        'Ã¢' => 'â',
        'Ã¤' => 'ä',
        'Ã¹' => 'ù',
        'Ã»' => 'û',
        'Ã¼' => 'ü',
        'Ã§' => 'ç',
        'Ã®' => 'î',
        'Ã¯' => 'ï',
        'à´' => 'ô',

        // Majuscules accentuées
        'Ã' => 'É',
        'Ã‰' => 'É',
        'Ãˆ' => 'È',
        'ÃŠ' => 'Ê',
        'Ã‹' => 'Ë',
        'Ã€' => 'À',
        'Ã‚' => 'Â',
        'Ã„' => 'Ä',
        'Ã™' => 'Ù',
        'Ã›' => 'Û',
        'Ãœ' => 'Ü',
        'Ã‡' => 'Ç',
        'ÃŽ' => 'Î',
        'Ã' => 'Ï',

        // Caractères spéciaux
        'â¬' => '€',   // Euro
        'â‚¬' => '€',
        'â' => '–',   // Tiret
        'â' => '—',   // Tiret long
        'â' => '‘',   // Apostrophe ouvrante
        'â' => '’',   // Apostrophe fermante
        'âœ' => '“',   // Guillemets doubles ouvrants
        'â' => '”',   // Guillemets doubles fermants
        'â¦' => '…',   // Points de suspension
        'Â«'  => '«',   // Guillemets français ouvrants
        'Â»'  => '»',   // Guillemets français fermants
        'Â'   => '',    // Espace insécable mal encodé (avant les lettres)
    ];
    $str = strtr($str, $remplacements);
    $str = preg_replace('/Ã\p{C}*/u', 'à', $str);
    $str = preg_replace('/Ã\h*/', 'à', $str);
    $str = preg_replace('/[^\P{C}\p{C}]+/u', '', $str);
    $str = preg_replace('/\s+/', ' ', trim($str));
    //$str = preg_replace('/[[:^print:]]/', '', $str);
    return $str;
}
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_calendrier");
//info
$test=0;
foreach($checks as $check) {
	$info = $check['info'];
    $date = $check['date'];
	if (!is_null($info) && $info !== '') {
		if (!is_utf8($info)) {
	        // Si l'encodage est incorrect, appliquer la conversion
	        $info_corrige = mb_convert_encoding($info, 'UTF-8', 'ISO-8859-1');
	        // Mise à jour de la ligne dans la base de données
	    }
	    else {
            // Si déjà en UTF-8, utiliser la chaîne d'origine
            $info_corrige = $info;
        }
        // Remplacer les caractères problématiques
        $info_corrige = corriger_caracteres($info_corrige);
	    $update_query = "UPDATE ".$prefix."_calendrier 
                         SET info = ? 
                         WHERE date = ?";
        $stmt = mysqli_prepare($bdd, $update_query);
        mysqli_stmt_bind_param($stmt, "ss", $info_corrige, $date);

        if (mysqli_stmt_execute($stmt)) {
            $test++;
        }
    }
}
echo "<li>table ".$prefix."_calendrier.</li>";
$test=0;
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_edtbrik");
//summary + textelibre
foreach($checks as $check) {
	$summary = $check['summary'];
    $textelibre = $check['textelibre'];
    $brik_id = $check['brik_id'];
	$summary_corrige = $summary;
    $textelibre_corrige = $textelibre;
	if (!is_null($summary) && $summary !== '') {
        if (!is_utf8($summary)) {
            $summary_corrige = mb_convert_encoding($summary, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $summary_corrige = $summary;
        }
        $summary_corrige = corriger_caracteres($summary_corrige);
    }
    if (!is_null($textelibre) && $textelibre !== '') {
        if (!is_utf8($textelibre)) {
            $textelibre_corrige = mb_convert_encoding($textelibre, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $textelibre_corrige = $textelibre;
        }
        $textelibre_corrige = corriger_caracteres($textelibre_corrige);
    }
    $update_query = "UPDATE ".$prefix."_edtbrik 
                         SET summary = ?, textelibre = ? 
                         WHERE brik_id = ?";
    $stmt = mysqli_prepare($bdd, $update_query);
    mysqli_stmt_bind_param($stmt, "sss", $summary_corrige, $textelibre_corrige, $brik_id);

    if (mysqli_stmt_execute($stmt)) {
       $test++;
    }    
}
echo "<li>table ".$prefix."_edtbrik.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_edtcode");
$test=0;
// code + nom
foreach($checks as $check) {
	$code = $check['code'];
    $nom = $check['nom'];
    $code_id = $check['code_id'];
	$code_corrige = $code;
    $nom_corrige = $nom;
	if (!is_null($code) && $code !== '') {
        if (!is_utf8($code)) {
            $code_corrige = mb_convert_encoding($code, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $code_corrige = $code;
        }
        $code_corrige = corriger_caracteres($code_corrige);
    }
    if (!is_null($nom) && $nom !== '') {
        if (!is_utf8($nom)) {
            $nom_corrige = mb_convert_encoding($nom, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $nom_corrige = $nom;
        }
        $nom_corrige = corriger_caracteres($nom_corrige);
    }
    $update_query = "UPDATE ".$prefix."_edtcode 
                         SET code = ?, nom = ? 
                         WHERE code_id = ?";
    $stmt = mysqli_prepare($bdd, $update_query);
    mysqli_stmt_bind_param($stmt, "sss", $code_corrige, $nom_corrige, $code_id);

    if (mysqli_stmt_execute($stmt)) {
        $test++;
    }
}
echo "<li>table ".$prefix."_edtcode.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_eleves");
// nom + prenom
foreach($checks as $check) {
	$nom = $check['nom'];
    $prenom = $check['prenom'];
    $eleves_id = $check['eleves_id'];
	$nom_corrige = $nom;
    $prenom_corrige = $prenom;
	if (!is_null($nom) && $nom !== '') {
        if (!is_utf8($nom)) {
            $nom_corrige = mb_convert_encoding($nom, 'UTF-8', 'ISO-8859-1');
        }
        $nom_corrige = corriger_caracteres($nom_corrige);
    }
    if (!is_null($prenom) && $prenom !== '') {
        if (!is_utf8($prenom)) {
            $prenom_corrige = mb_convert_encoding($prenom, 'UTF-8', 'ISO-8859-1');
        }
        $prenom_corrige = corriger_caracteres($prenom_corrige);
    }
    $update_query = "UPDATE ".$prefix."_eleves 
                         SET nom = ?, prenom = ? 
                         WHERE eleves_id = ?";
    $stmt = mysqli_prepare($bdd, $update_query);
    mysqli_stmt_bind_param($stmt, "sss", $nom_corrige, $prenom_corrige, $eleves_id);

    if (mysqli_stmt_execute($stmt)) {
        $test++;
    }
}
echo "<li>table ".$prefix."_eleves.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_espaces");
// espace_nom
foreach($checks as $check) {
	$espace_nom = $check['espace_nom'];
    $espace_id = $check['espace_id'];
	if (!is_null($espace_nom) && $espace_nom !== '') {
		if (!is_utf8($espace_nom)) {
	        // Si l'encodage est incorrect, appliquer la conversion
	        $espace_nom_corrige = mb_convert_encoding($espace_nom, 'UTF-8', 'ISO-8859-1');
	        // Mise à jour de la ligne dans la base de données
	    }
	    else {
            // Si déjà en UTF-8, utiliser la chaîne d'origine
            $espace_nom_corrige = $espace_nom;
        }
        // Remplacer les caractères problématiques
        $espace_nom_corrige = corriger_caracteres($espace_nom_corrige);
	    $update_query = "UPDATE ".$prefix."_espaces 
                         SET espace_nom = ? 
                         WHERE espace_id = ?";
        $stmt = mysqli_prepare($bdd, $update_query);
        mysqli_stmt_bind_param($stmt, "ss", $espace_nom_corrige, $espace_id);

        if (mysqli_stmt_execute($stmt)) {
            $test++;
        }
    }
}
echo "<li>table ".$prefix."_espaces.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_etab");
// nom + adresse + ville + mail
foreach($checks as $check) {
	$nom = $check['nom'];
    $adresse = $check['adresse'];
    $ville = $check['ville'];
    $mail = $check['mail'];
    $academie = $check['academie'];
    $etab_id = $check['etab_id'];
	$nom_corrige = $nom;
    $adresse_corrige = $adresse;
    $ville_corrige = $ville;
    $mail_corrige = $mail;
    $academie_corrige = $academie;
	if (!is_null($nom) && $nom !== '') {
        if (!is_utf8($nom)) {
            $nom_corrige = mb_convert_encoding($nom, 'UTF-8', 'ISO-8859-1');
        }
        $nom_corrige = corriger_caracteres($nom_corrige);
    }
    if (!is_null($adresse) && $adresse !== '') {
        if (!is_utf8($adresse)) {
            $adresse_corrige = mb_convert_encoding($adresse, 'UTF-8', 'ISO-8859-1');
        }
        $adresse_corrige = corriger_caracteres($adresse_corrige);
    }
    if (!is_null($ville) && $ville !== '') {
        if (!is_utf8($ville)) {
            $ville_corrige = mb_convert_encoding($ville, 'UTF-8', 'ISO-8859-1');
        }
        $ville_corrige = corriger_caracteres($ville_corrige);
    }
    if (!is_null($mail) && $mail !== '') {
        if (!is_utf8($mail)) {
            $mail_corrige = mb_convert_encoding($mail, 'UTF-8', 'ISO-8859-1');
        }
        $mail_corrige = corriger_caracteres($mail_corrige);
    }
    if (!is_null($academie) && $academie !== '') {
        if (!is_utf8($academie)) {
            $academie_corrige = mb_convert_encoding($academie, 'UTF-8', 'ISO-8859-1');
        }
        $academie_corrige = corriger_caracteres($academie_corrige);
    }
    $update_query = "UPDATE ".$prefix."_etab 
                         SET nom = ?, adresse = ?, ville = ?, mail = ?, academie = ? 
                         WHERE etab_id = ?";
    $stmt = mysqli_prepare($bdd, $update_query);
    mysqli_stmt_bind_param($stmt, "ssssss", $nom_corrige, $adresse_corrige, $ville_corrige, $mail_corrige, $academie_corrige, $eleves_id);

    if (mysqli_stmt_execute($stmt)) {
        $test++;
    }
}
echo "<li>table ".$prefix."_etab.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_exclucauses");
// exclucause_txt
foreach($checks as $check) {
	$exclucause_txt = $check['exclucause_txt'];
    $exclucause_id = $check['exclucause_id'];
	if (!is_null($exclucause_txt) && $exclucause_txt !== '') {
		if (!is_utf8($exclucause_txt)) {
	        $exclucause_txt_corrige = mb_convert_encoding($exclucause_txt, 'UTF-8', 'ISO-8859-1');
	    }
	    else {
            $exclucause_txt_corrige = $exclucause_txt;
        }
        $exclucause_txt_corrige = corriger_caracteres($exclucause_txt_corrige);
	    $update_query = "UPDATE ".$prefix."_exclucauses 
                         SET exclucause_txt = ? 
                         WHERE exclucause_id = ?";
        $stmt = mysqli_prepare($bdd, $update_query);
        mysqli_stmt_bind_param($stmt, "ss", $exclucause_txt_corrige, $exclucause_id);

        if (mysqli_stmt_execute($stmt)) {
            $test++;
        }
    }
}
echo "<li>table ".$prefix."_exclucauses.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_freqactiv");
// nom_activ
foreach($checks as $check) {
    $nom_activ = $check['nom_activ'];
    $activ_id = $check['activ_id'];
    if (!is_null($nom_activ) && $nom_activ !== '') {
        if (!is_utf8($nom_activ)) {
            $nom_activ_corrige = mb_convert_encoding($nom_activ, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $nom_activ_corrige = $nom_activ;
        }
        $nom_activ_corrige = corriger_caracteres($nom_activ_corrige);
        $update_query = "UPDATE ".$prefix."_freqactiv 
                         SET nom_activ = ? 
                         WHERE activ_id = ?";
        $stmt = mysqli_prepare($bdd, $update_query);
        mysqli_stmt_bind_param($stmt, "ss", $nom_activ_corrige, $activ_id);

        if (mysqli_stmt_execute($stmt)) {
            $test++;
        }
    }
}
echo "<li>table ".$prefix."_freqactiv.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_groupes");
// groupe_nom + groupe_desc
foreach($checks as $check) {
	$groupe_nom = $check['groupe_nom'];
    $groupe_desc = $check['groupe_desc'];
    $groupe_id = $check['groupe_id'];
	$groupe_nom_corrige = $groupe_nom;
    $groupe_desc_corrige = $groupe_desc;
	if (!is_null($groupe_nom) && $groupe_nom !== '') {
        if (!is_utf8($groupe_nom)) {
            $groupe_nom_corrige = mb_convert_encoding($groupe_nom, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $groupe_nom_corrige = $groupe_nom;
        }
        $groupe_nom_corrige = corriger_caracteres($groupe_nom_corrige);
    }
    if (!is_null($groupe_desc) && $groupe_desc !== '') {
        if (!is_utf8($groupe_desc)) {
            $groupe_desc_corrige = mb_convert_encoding($groupe_desc, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $groupe_desc_corrige = $groupe_desc;
        }
        $groupe_desc_corrige = corriger_caracteres($groupe_desc_corrige);
    }
    $update_query = "UPDATE ".$prefix."_groupes 
                         SET groupe_nom = ?, groupe_desc = ? 
                         WHERE groupe_id = ?";
    $stmt = mysqli_prepare($bdd, $update_query);
    mysqli_stmt_bind_param($stmt, "sss", $groupe_nom_corrige, $groupe_desc_corrige, $groupe_id);

    if (mysqli_stmt_execute($stmt)) {
        $test++;
    }
}
echo "<li>table ".$prefix."_groupes.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_limitstxt");
// limits_txt
foreach($checks as $check) {
    $limits_txt = $check['limits_txt'];
    $limittxt_id = $check['limittxt_id'];
    if (!is_null($limits_txt) && $limits_txt !== '') {
        if (!is_utf8($limits_txt)) {
            $limits_txt_corrige = mb_convert_encoding($limits_txt, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $limits_txt_corrige = $limits_txt;
        }
        $limits_txt_corrige = corriger_caracteres($limits_txt_corrige);
        $update_query = "UPDATE ".$prefix."_limitstxt 
                         SET limits_txt = ? 
                         WHERE limittxt_id = ?";
        $stmt = mysqli_prepare($bdd, $update_query);
        mysqli_stmt_bind_param($stmt, "ss", $limits_txt_corrige, $limittxt_id);

        if (mysqli_stmt_execute($stmt)) {
            $test++;
        }
    }
}
echo "<li>table ".$prefix."_limitstxt.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_parametres");
// valeur + comments
foreach($checks as $check) {
	$valeur = $check['valeur'];
    $comments = $check['comments'];
    $param_id = $check['param_id'];
	$valeur_corrige = $valeur;
    $comments_corrige = $comments;
	if (!is_null($valeur) && $valeur !== '') {
        if (!is_utf8($valeur)) {
            $valeur_corrige = mb_convert_encoding($valeur, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $valeur_corrige = $valeur;
        }
        $valeur_corrige = corriger_caracteres($valeur_corrige);
    }
    if (!is_null($comments) && $comments !== '') {
        if (!is_utf8($comments)) {
            $comments_corrige = mb_convert_encoding($comments, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $comments_corrige = $comments;
        }
        $comments_corrige = corriger_caracteres($comments_corrige);
    }
    $update_query = "UPDATE ".$prefix."_parametres 
                         SET valeur = ?, comments = ? 
                         WHERE param_id = ?";
    $stmt = mysqli_prepare($bdd, $update_query);
    mysqli_stmt_bind_param($stmt, "sss", $valeur_corrige, $comments_corrige, $param_id);

    if (mysqli_stmt_execute($stmt)) {
        $test++;
    }
}
echo "<li>table ".$prefix."_parametres.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_periodes");
// nom
foreach($checks as $check) {
    $nom = $check['nom'];
    $period_id = $check['period_id'];
    if (!is_null($nom) && $nom !== '') {
        if (!is_utf8($nom)) {
            $nom_corrige = mb_convert_encoding($nom, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $nom_corrige = $nom;
        }
        $nom_corrige = corriger_caracteres($nom_corrige);
        $update_query = "UPDATE ".$prefix."_periodes 
                         SET nom = ? 
                         WHERE period_id = ?";
        $stmt = mysqli_prepare($bdd, $update_query);
        mysqli_stmt_bind_param($stmt, "ss", $nom_corrige, $period_id);

        if (mysqli_stmt_execute($stmt)) {
            $test++;
        }
    }
}
echo "<li>table ".$prefix."_periodes.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_retards");
// titre
foreach($checks as $check) {
    $titre = $check['titre'];
    $retards_id = $check['retards_id'];
    if (!is_null($titre) && $titre !== '') {
        if (!is_utf8($titre)) {
            $titre_corrige = mb_convert_encoding($titre, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $titre_corrige = $titre;
        }
        $titre_corrige = corriger_caracteres($titre_corrige);
        $update_query = "UPDATE ".$prefix."_retards 
                         SET titre = ? 
                         WHERE retards_id = ?";
        $stmt = mysqli_prepare($bdd, $update_query);
        mysqli_stmt_bind_param($stmt, "ss", $titre_corrige, $retards_id);

        if (mysqli_stmt_execute($stmt)) {
            $test++;
        }
    }
}
echo "<li>table ".$prefix."_retards.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_savchamps");
// champs_nom
foreach($checks as $check) {
    $champs_nom = $check['champs_nom'];
    $champs_id = $check['champs_id'];
    if (!is_null($champs_nom) && $champs_nom !== '') {
        if (!is_utf8($champs_nom)) {
            $champs_nom_corrige = mb_convert_encoding($champs_nom, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $champs_nom_corrige = $champs_nom;
        }
        $champs_nom_corrige = corriger_caracteres($champs_nom_corrige);
        $update_query = "UPDATE ".$prefix."_savchamps 
                         SET champs_nom = ? 
                         WHERE champs_id = ?";
        $stmt = mysqli_prepare($bdd, $update_query);
        mysqli_stmt_bind_param($stmt, "ss", $champs_nom_corrige, $champs_id);

        if (mysqli_stmt_execute($stmt)) {
            $test++;
        }
    }
}
echo "<li>table ".$prefix."_savchamps.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_savnotions");
// notion_nom
foreach($checks as $check) {
    $notion_nom = $check['notion_nom'];
    $notion_id = $check['notion_id'];
    if (!is_null($notion_nom) && $notion_nom !== '') {
        if (!is_utf8($notion_nom)) {
            $notion_nom_corrige = mb_convert_encoding($notion_nom, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $notion_nom_corrige = $notion_nom;
        }
        $notion_nom_corrige = corriger_caracteres($notion_nom_corrige);
        $update_query = "UPDATE ".$prefix."_savnotions 
                         SET notion_nom = ? 
                         WHERE notion_id = ?";
        $stmt = mysqli_prepare($bdd, $update_query);
        mysqli_stmt_bind_param($stmt, "ss", $notion_nom_corrige, $notion_id);

        if (mysqli_stmt_execute($stmt)) {
            $test++;
        }
    }
}
echo "<li>table ".$prefix."_savnotions.</li>";
// SAVOIRS :
$tables = ['1', '2', '3', '4', '5', '6', 't'];
// Parcourir chaque suffixe pour traiter les différentes tables
foreach ($tables as $suffix) {
    $table_name = $prefix . "_savoirs" . $suffix;  // Générer dynamiquement le nom de la table
    $id_column = "s" . $suffix . "_id";            // Générer dynamiquement le nom de la colonne ID
    // Récupérer les données de la table
    $checks = mysqli_query($bdd, "SELECT * FROM $table_name");

    // Parcourir chaque ligne de la table
    foreach ($checks as $check) {
        $nom_savoir = $check['nom_savoir'];
        $notions = $check['notions'];
        $id = $check[$id_column];

        // Préparer les colonnes à corriger
        $colonnes_a_corriger = ['nom_savoir', 'notions'];
        $set_clauses = [];
        $params = [];
        $types = '';  // Types des paramètres pour bind_param

        foreach ($colonnes_a_corriger as $colonne) {
            $valeur = $check[$colonne];

            // Vérifier et corriger l'encodage
            if (!is_null($valeur) && $valeur !== '') {
                if (!is_utf8($valeur)) {
                    $valeur_corrigee = mb_convert_encoding($valeur, 'UTF-8', 'ISO-8859-1');
                } else {
                    $valeur_corrigee = $valeur;
                }

                // Corriger les caractères spécifiques
                $valeur_corrigee = corriger_caracteres($valeur_corrigee);

                // Ajouter la colonne à l'UPDATE
                $set_clauses[] = "$colonne = ?";
                $params[] = $valeur_corrigee;
                $types .= 's';  // Type string pour chaque colonne
            }
        }

        // Si des colonnes ont été corrigées, préparer l'UPDATE
        if (!empty($set_clauses)) {
            $params[] = $id;  // Ajouter l'ID à la fin des paramètres
            $types .= 's';     // Type string pour l'ID

            // Construire la requête d'UPDATE
            $update_query = "UPDATE $table_name SET " . implode(', ', $set_clauses) . " WHERE $id_column = ?";
            
            // Préparer et exécuter la requête
            $stmt = mysqli_prepare($bdd, $update_query);
            if ($stmt) {
                // Lier les paramètres dynamiquement
                mysqli_stmt_bind_param($stmt, $types, ...$params);

                // Exécuter la requête
                if (mysqli_stmt_execute($stmt)) {
                    $test++;
                } 
            } 
        }
    }
    echo "<li>table ".$prefix."_savoirs". $suffix.".</li>";
}
$colonnes = ['seq_nom', 'contexte', 'intervs', 'enjeux', 'requis','notions','curriculum','emi','socle','autres','production','calendrier','ressources','synopsis','outils1','outils2','eval','reinves','bilan','conseils','auteur','licence','url'];
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_sequences");
// ALL
foreach ($checks as $check) {
    $seq_id = $check['seq_id'];  // Identifiant unique pour l'UPDATE    
    // Variables pour stocker les valeurs corrigées et les paramètres pour l'UPDATE
    $set_clauses = [];
    $params = [];
    $types = '';  // Types des paramètres pour bind_param

    foreach ($colonnes as $colonne) {
        $valeur = $check[$colonne];

        if (!is_null($valeur) && $valeur !== '') {
            // Vérifier si la colonne est encodée correctement en UTF-8
            if (!is_utf8($valeur)) {
                $valeur_corrigee = mb_convert_encoding($valeur, 'UTF-8', 'ISO-8859-1');
            } else {
                $valeur_corrigee = $valeur;
            }

            // Corriger les caractères mal encodés
            $valeur_corrigee = corriger_caracteres($valeur_corrigee);

            // Ajouter cette colonne à l'UPDATE
            $set_clauses[] = "$colonne = ?";
            $params[] = $valeur_corrigee;
            $types .= 's';  // Type de chaque colonne, ici 's' pour string
        }
    }

    // Si des colonnes ont été corrigées, préparer l'UPDATE
    if (!empty($set_clauses)) {
        // Construire la requête d'UPDATE
        $update_query = "UPDATE ".$prefix."_sequences 
                         SET " . implode(', ', $set_clauses) . " 
                         WHERE seq_id = ?";
        $params[] = $seq_id;  // Ajouter l'ID à la fin des paramètres
        $types .= 's';  // Type pour l'ID

        // Préparer la requête
        $stmt = mysqli_prepare($bdd, $update_query);

        if ($stmt) {
            // Lier les paramètres dynamiquement
            mysqli_stmt_bind_param($stmt, $types, ...$params);

            // Exécuter la requête
            if (mysqli_stmt_execute($stmt)) {
                $test++;  // Compteur de succès, optionnel
            }
        } 
    }
}
echo "<li>table ".$prefix."_sequences.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_sigbresas");
// titre
foreach($checks as $check) {
    $titre = $check['titre'];
    $resas_id = $check['resas_id'];
    if (!is_null($titre) && $titre !== '') {
        if (!is_utf8($titre)) {
            $titre_corrige = mb_convert_encoding($titre, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $titre_corrige = $titre;
        }
        $titre_corrige = corriger_caracteres($titre_corrige);
        $update_query = "UPDATE ".$prefix."_sigbresas 
                         SET titre = ? 
                         WHERE resas_id = ?";
        $stmt = mysqli_prepare($bdd, $update_query);
        mysqli_stmt_bind_param($stmt, "ss", $titre_corrige, $resas_id);

        if (mysqli_stmt_execute($stmt)) {
            $test++;
        }
    }
}
echo "<li>table ".$prefix."_sigbresas.</li>";
$checks = mysqli_query($bdd, "SELECT * FROM ".$prefix."_user");
// nom + prenom
foreach($checks as $check) {
	$nom = $check['nom'];
    $prenom = $check['prenom'];
    $id = $check['id'];
	$nom_corrige = $nom;
    $prenom_corrige = $prenom;
	if (!is_null($nom) && $nom !== '') {
        if (!is_utf8($nom)) {
            $nom_corrige = mb_convert_encoding($nom, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $nom_corrige = $nom;
        }
        $nom_corrige = corriger_caracteres($nom_corrige);
    }
    if (!is_null($prenom) && $prenom !== '') {
        if (!is_utf8($prenom)) {
            $prenom_corrige = mb_convert_encoding($prenom, 'UTF-8', 'ISO-8859-1');
        }
        else {
            $prenom_corrige = $prenom;
        }
        $prenom_corrige = corriger_caracteres($prenom_corrige);
    }
    $update_query = "UPDATE ".$prefix."_user 
                         SET nom = ?, prenom = ? 
                         WHERE id = ?";
    $stmt = mysqli_prepare($bdd, $update_query);
    mysqli_stmt_bind_param($stmt, "sss", $nom_corrige, $prenom_corrige, $id);

    if (mysqli_stmt_execute($stmt)) {
        $test++;
    }
}
echo "<li>table ".$prefix."_user.</li>";
?>