SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de données : `idlog`
--

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_agenda`
--

CREATE TABLE `preidlog_agenda` (
  `agenda_id` int(11) NOT NULL,
  `creator` int(11) NOT NULL,
  `users` varchar(100) DEFAULT NULL,
  `espaces` varchar(100) DEFAULT NULL,
  `titre` varchar(200) NOT NULL,
  `texte` text DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `date1` date NOT NULL,
  `date2` date DEFAULT NULL,
  `options` varchar(200) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_barcodes`
--

CREATE TABLE `preidlog_barcodes` (
  `bcmodele_id` int(11) NOT NULL,
  `nom` varchar(30) NOT NULL,
  `typusage` varchar(30) NOT NULL,
  `format` varchar(1) DEFAULT NULL,
  `nbwidth` int(11) DEFAULT NULL,
  `nbheight` int(11) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `margextg` int(11) DEFAULT NULL,
  `margextd` int(11) DEFAULT NULL,
  `margexth` int(11) DEFAULT NULL,
  `margextb` int(11) DEFAULT NULL,
  `margintg` int(11) DEFAULT NULL,
  `margintd` int(11) DEFAULT NULL,
  `marginth` int(11) DEFAULT NULL,
  `margintb` int(11) DEFAULT NULL,
  `textup` int(11) DEFAULT NULL,
  `textspe` varchar(50) DEFAULT NULL,
  `textupsize` int(11) DEFAULT NULL,
  `fontsize` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_calendrier`
--

CREATE TABLE `preidlog_calendrier` (
  `date` date NOT NULL,
  `statut` int(11) NOT NULL,
  `info` varchar(200) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_edtbrik`
--

CREATE TABLE `preidlog_edtbrik` (
  `brik_id` int(11) NOT NULL,
  `code` varchar(10) NOT NULL,
  `summary` varchar(50) NOT NULL,
  `seq_id` int(11) NOT NULL,
  `division` text NOT NULL,
  `textelibre` varchar(30) NOT NULL,
  `activ_brik` int(11) NOT NULL,
  `close` int(11) DEFAULT NULL,
  `seance` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_edtcode`
--

CREATE TABLE `preidlog_edtcode` (
  `code_id` int(11) NOT NULL,
  `code` varchar(100) NOT NULL,
  `nom` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `activ_code` int(11) NOT NULL,
  `default_code` int(11) NOT NULL,
  `bgcolor_code` varchar(7) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_edtevent`
--

CREATE TABLE `preidlog_edtevent` (
  `uid` int(11) NOT NULL,
  `dtstart` varchar(15) NOT NULL,
  `dtend` varchar(15) NOT NULL,
  `hor_id` int(11) NOT NULL,
  `week` int(11) NOT NULL,
  `brik_id` int(11) NOT NULL,
  `seq_id` int(11) NOT NULL,
  `hor_name` varchar(2) DEFAULT NULL,
  `specifique` int(11) DEFAULT 0,
  `duration` int(11) DEFAULT 10
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_edtnivcolor`
--

CREATE TABLE `preidlog_edtnivcolor` (
  `id` int(11) NOT NULL,
  `niveau` varchar(10) DEFAULT NULL,
  `bgcolor` varchar(7) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_eleves`
--

CREATE TABLE `preidlog_eleves` (
  `eleves_id` int(11) NOT NULL,
  `nom` text NOT NULL,
  `prenom` text NOT NULL,
  `division` text NOT NULL,
  `naissance` date DEFAULT NULL,
  `sexe` char(1) DEFAULT NULL,
  `code` varchar(50) DEFAULT NULL,
  `mdp` varchar(200) DEFAULT NULL,
  `mail` varchar(200) DEFAULT NULL,
  `auth_mail` int(11) DEFAULT NULL,
  `id_perso` varchar(50) DEFAULT NULL,
  `id_constr` varchar(50) DEFAULT NULL,
  `sel` varchar(200) DEFAULT 'NULL',
  `lang` varchar(10) DEFAULT NULL,
  `add1` varchar(200) DEFAULT NULL,
  `add2` varchar(200) DEFAULT NULL,
  `cpostal` varchar(10) DEFAULT NULL,
  `ville` varchar(100) DEFAULT NULL,
  `categ` int(11) NOT NULL,
  `resp_nom` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_elevesmaj`
--

CREATE TABLE `preidlog_elevesmaj` (
  `eleves_id` int(11) NOT NULL,
  `nom` text NOT NULL,
  `prenom` text NOT NULL,
  `division` text NOT NULL,
  `naissance` date DEFAULT NULL,
  `sexe` char(1) DEFAULT NULL,
  `code` varchar(50) DEFAULT NULL,
  `mdp` varchar(200) DEFAULT NULL,
  `mail` varchar(200) DEFAULT NULL,
  `id_perso` varchar(50) DEFAULT NULL,
  `sel` varchar(200) DEFAULT 'NULL',
  `add1` varchar(200) DEFAULT NULL,
  `add2` varchar(200) DEFAULT NULL,
  `cpostal` varchar(10) DEFAULT NULL,
  `ville` varchar(100) DEFAULT NULL,
  `categ` int(11) NOT NULL,
  `resp_nom` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_espaces`
--

CREATE TABLE `preidlog_espaces` (
  `espace_id` int(11) NOT NULL,
  `espace_nom` varchar(30) NOT NULL,
  `seuilnbi` int(11) DEFAULT NULL,
  `seuilreaci` varchar(30) DEFAULT NULL,
  `seuilnbr` int(11) DEFAULT NULL,
  `seuilreacr` varchar(30) DEFAULT NULL,
  `espace_bg` varchar(30) DEFAULT NULL,
  `default_espace` int(11) DEFAULT NULL,
  `resa` int(11) DEFAULT NULL,
  `resa_dist` int(11) DEFAULT NULL,
  `auth_freq` int(11) DEFAULT NULL,
  `edtopt` int(11) DEFAULT 0,
  `edtoptresa` int(11) DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_espaces_event`
--

CREATE TABLE `preidlog_espaces_event` (
  `espace_id` int(11) NOT NULL,
  `uid` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_etab`
--

CREATE TABLE `preidlog_etab` (
  `etab_id` int(11) NOT NULL,
  `nom` varchar(100) DEFAULT NULL,
  `adresse` varchar(200) DEFAULT NULL,
  `cp` varchar(5) DEFAULT NULL,
  `ville` varchar(100) DEFAULT NULL,
  `tel` char(20) DEFAULT NULL,
  `fax` char(20) DEFAULT NULL,
  `mail` varchar(200) DEFAULT NULL,
  `rne` char(10) DEFAULT NULL,
  `academie` text NOT NULL,
  `pays` varchar(5) DEFAULT NULL,
  `lieu_nom` varchar(50) DEFAULT NULL,
  `lieu_genre` varchar(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_etab_effectifs`
--

CREATE TABLE `preidlog_etab_effectifs` (
  `etab_id` int(11) DEFAULT NULL,
  `anneesco` varchar(100) NOT NULL,
  `division` varchar(30) NOT NULL,
  `effectif` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_exclucauses`
--

CREATE TABLE `preidlog_exclucauses` (
  `exclucause_id` int(11) NOT NULL,
  `exclucause_txt` varchar(50) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_exclusions`
--

CREATE TABLE `preidlog_exclusions` (
  `exclusion_id` int(11) NOT NULL,
  `eleves_id` int(11) DEFAULT NULL,
  `exclucause_id` int(11) DEFAULT NULL,
  `date_exclusion` date DEFAULT NULL,
  `date_info` date DEFAULT NULL,
  `date_fin` date DEFAULT NULL,
  `excluactivs` varchar(200) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_freq`
--

CREATE TABLE `preidlog_freq` (
  `freq_id` int(11) NOT NULL,
  `eleves_id` int(11) NOT NULL,
  `date_freq` date NOT NULL,
  `code_freq` varchar(30) NOT NULL,
  `cas` varchar(3) NOT NULL,
  `division` text NOT NULL,
  `sexe` char(1) DEFAULT NULL,
  `h_inscription` varchar(15) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `espace_id` int(11) DEFAULT NULL,
  `hor_name` varchar(2) DEFAULT NULL,
  `code_activ` varchar(4) DEFAULT NULL,
  `code_activ2` varchar(4) DEFAULT NULL,
  `code_activ3` varchar(4) DEFAULT NULL,
  `h_sortie` varchar(15) DEFAULT NULL,
  `h_inscription2` varchar(15) DEFAULT NULL,
  `h_sortie_2` varchar(15) DEFAULT NULL,
  `h_inscription3` varchar(15) DEFAULT NULL,
  `h_sortie_3` varchar(15) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_freqactiv`
--

CREATE TABLE `preidlog_freqactiv` (
  `activ_id` int(11) NOT NULL,
  `code_activ` varchar(4) NOT NULL,
  `nom_activ` varchar(100) DEFAULT NULL,
  `activ_activ` int(11) NOT NULL,
  `default_activ` int(11) NOT NULL,
  `consult_activ` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_freqgrappes`
--

CREATE TABLE `preidlog_freqgrappes` (
  `freqgrap_id` int(11) NOT NULL,
  `nombre` int(11) NOT NULL,
  `division` text DEFAULT NULL,
  `niveau` varchar(2) DEFAULT NULL,
  `date_freq` date NOT NULL,
  `dtstart` varchar(15) DEFAULT NULL,
  `code_freq` varchar(30) DEFAULT NULL,
  `passage` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `espace_id` int(11) DEFAULT NULL,
  `hor_name` varchar(2) DEFAULT NULL,
  `code_activ` varchar(4) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_freqres`
--

CREATE TABLE `preidlog_freqres` (
  `freqres_id` int(11) NOT NULL,
  `eleves_id` int(11) NOT NULL,
  `date_freqres` date NOT NULL,
  `code_freqres` varchar(25) NOT NULL,
  `hor_name` varchar(2) NOT NULL,
  `espace_id` int(11) DEFAULT NULL,
  `activ_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `raison` text DEFAULT NULL,
  `statut` int(11) NOT NULL,
  `division` varchar(200) DEFAULT NULL,
  `sexe` char(1) DEFAULT NULL,
  `code_activ` varchar(4) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_freqresref`
--

CREATE TABLE `preidlog_freqresref` (
  `refus_id` int(11) NOT NULL,
  `eleves_id` int(11) NOT NULL,
  `todate` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_groupele`
--

CREATE TABLE `preidlog_groupele` (
  `groupe_id` int(11) NOT NULL,
  `eleves_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_groupes`
--

CREATE TABLE `preidlog_groupes` (
  `groupe_id` int(11) NOT NULL,
  `groupe_nom` varchar(20) NOT NULL,
  `groupe_desc` text DEFAULT NULL,
  `groupe_actif` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_horaires`
--

CREATE TABLE `preidlog_horaires` (
  `hor_id` int(11) NOT NULL,
  `hor_name` varchar(2) NOT NULL,
  `num_creneau` int(11) NOT NULL,
  `debut` time NOT NULL,
  `fin` time NOT NULL,
  `hor_freq` varchar(100) DEFAULT NULL,
  `quota_freq` varchar(100) DEFAULT NULL,
  `hor_resa` varchar(100) DEFAULT NULL,
  `quota_resa` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_hordemis`
--

CREATE TABLE `preidlog_hordemis` (
  `id` int(11) NOT NULL,
  `demijour` varchar(5) NOT NULL,
  `statut` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_limits`
--

CREATE TABLE `preidlog_limits` (
  `limit_id` int(11) NOT NULL,
  `eleves_id` int(11) DEFAULT NULL,
  `limittxt_id` int(11) DEFAULT NULL,
  `date_debut` date DEFAULT NULL,
  `date_fin` date DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_limitstxt`
--

CREATE TABLE `preidlog_limitstxt` (
  `limittxt_id` int(11) NOT NULL,
  `limits_txt` varchar(100) NOT NULL,
  `espace_id` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_parametres`
--

CREATE TABLE `preidlog_parametres` (
  `param_id` int(11) NOT NULL,
  `param_nom` varchar(30) NOT NULL,
  `valeur` varchar(300) DEFAULT NULL,
  `comments` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_periodes`
--

CREATE TABLE `preidlog_periodes` (
  `period_id` int(11) NOT NULL,
  `nom` varchar(100) DEFAULT NULL,
  `anneesco` varchar(100) NOT NULL,
  `periodes` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_retards`
--

CREATE TABLE `preidlog_retards` (
  `retards_id` int(11) NOT NULL,
  `eleves_id` int(11) NOT NULL,
  `titre` varchar(100) NOT NULL,
  `retour_date` date NOT NULL,
  `niv_alerte` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_savchamps`
--

CREATE TABLE `preidlog_savchamps` (
  `sc_id` int(11) NOT NULL,
  `champs_id` varchar(10) NOT NULL,
  `champs_nom` text DEFAULT NULL,
  `bgcolor` varchar(7) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_savele`
--

CREATE TABLE `preidlog_savele` (
  `eleves_id` int(11) NOT NULL,
  `s_id` varchar(15) DEFAULT NULL,
  `eval` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_savnotions`
--

CREATE TABLE `preidlog_savnotions` (
  `notion_id` int(11) NOT NULL,
  `notion_nom` varchar(300) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_savoirs1`
--

CREATE TABLE `preidlog_savoirs1` (
  `s1_id` varchar(15) NOT NULL,
  `nom_savoir` text NOT NULL,
  `niveau` varchar(2) NOT NULL,
  `champs_id` varchar(10) DEFAULT NULL,
  `notions` text DEFAULT NULL,
  `base` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_savoirs2`
--

CREATE TABLE `preidlog_savoirs2` (
  `s2_id` varchar(15) NOT NULL,
  `nom_savoir` text NOT NULL,
  `niveau` varchar(2) NOT NULL,
  `champs_id` varchar(10) DEFAULT NULL,
  `notions` text DEFAULT NULL,
  `base` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_savoirs3`
--

CREATE TABLE `preidlog_savoirs3` (
  `s3_id` varchar(15) NOT NULL,
  `nom_savoir` text NOT NULL,
  `niveau` varchar(2) NOT NULL,
  `champs_id` varchar(10) DEFAULT NULL,
  `notions` text DEFAULT NULL,
  `base` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_savoirs4`
--

CREATE TABLE `preidlog_savoirs4` (
  `s4_id` varchar(15) NOT NULL,
  `nom_savoir` text NOT NULL,
  `niveau` varchar(2) NOT NULL,
  `champs_id` varchar(10) DEFAULT NULL,
  `notions` text DEFAULT NULL,
  `base` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_savoirs5`
--

CREATE TABLE `preidlog_savoirs5` (
  `s5_id` varchar(15) NOT NULL,
  `nom_savoir` text NOT NULL,
  `niveau` varchar(2) NOT NULL,
  `champs_id` varchar(10) DEFAULT NULL,
  `notions` text DEFAULT NULL,
  `base` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_savoirs6`
--

CREATE TABLE `preidlog_savoirs6` (
  `s6_id` varchar(15) NOT NULL,
  `nom_savoir` text NOT NULL,
  `niveau` varchar(2) NOT NULL,
  `champs_id` varchar(10) DEFAULT NULL,
  `notions` text DEFAULT NULL,
  `base` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_savoirsmaj`
--

CREATE TABLE `preidlog_savoirsmaj` (
  `s_id` varchar(15) NOT NULL,
  `nom_savoir` text NOT NULL,
  `niveau` varchar(2) NOT NULL,
  `champs_id` varchar(10) DEFAULT NULL,
  `notions` text DEFAULT NULL,
  `base` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_savoirst`
--

CREATE TABLE `preidlog_savoirst` (
  `st_id` varchar(15) NOT NULL,
  `nom_savoir` text NOT NULL,
  `niveau` varchar(2) NOT NULL,
  `champs_id` varchar(10) DEFAULT NULL,
  `notions` text DEFAULT NULL,
  `base` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_seqdocs`
--

CREATE TABLE `preidlog_seqdocs` (
  `doc_id` int(11) NOT NULL,
  `seq_id` int(11) NOT NULL,
  `docurl` text NOT NULL,
  `docname` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_seqeleves`
--

CREATE TABLE `preidlog_seqeleves` (
  `eleves_id` int(11) NOT NULL,
  `seq_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_seqnot`
--

CREATE TABLE `preidlog_seqnot` (
  `seq_id` int(11) NOT NULL,
  `notion_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_seqsav`
--

CREATE TABLE `preidlog_seqsav` (
  `seq_id` int(11) NOT NULL,
  `s_id` varchar(15) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_sequences`
--

CREATE TABLE `preidlog_sequences` (
  `seq_id` int(11) NOT NULL,
  `seq_nom` text NOT NULL,
  `contexte` text DEFAULT NULL,
  `niveau` varchar(10) NOT NULL,
  `intervs` text DEFAULT NULL,
  `enjeux` text DEFAULT NULL,
  `requis` text DEFAULT NULL,
  `notions` text DEFAULT NULL,
  `curriculum` text DEFAULT NULL,
  `emi` text DEFAULT NULL,
  `socle` text DEFAULT NULL,
  `autres` text DEFAULT NULL,
  `production` text DEFAULT NULL,
  `calendrier` text DEFAULT NULL,
  `ressources` text DEFAULT NULL,
  `synopsis` text DEFAULT NULL,
  `outils1` text DEFAULT NULL,
  `outils2` text DEFAULT NULL,
  `eval` text DEFAULT NULL,
  `reinves` text DEFAULT NULL,
  `bilan` text DEFAULT NULL,
  `conseils` text DEFAULT NULL,
  `auteur` text DEFAULT NULL,
  `licence` text DEFAULT NULL,
  `url` text DEFAULT NULL,
  `date_crea` date DEFAULT NULL,
  `date_maj` date DEFAULT NULL,
  `seq_actif` int(11) NOT NULL,
  `seq_complete` int(11) DEFAULT NULL,
  `progression` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_sigbresas`
--

CREATE TABLE `preidlog_sigbresas` (
  `resas_id` int(11) NOT NULL,
  `eleves_id` int(11) NOT NULL,
  `titre` varchar(100) DEFAULT NULL,
  `statut` varchar(100) DEFAULT NULL,
  `date_statut` date DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_tchat`
--

CREATE TABLE `preidlog_tchat` (
  `tchat_id` int(11) NOT NULL,
  `sender_id` int(11) NOT NULL,
  `receiver_id` int(11) NOT NULL,
  `message` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `is_read` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_user`
--

CREATE TABLE `preidlog_user` (
  `id` int(11) NOT NULL,
  `nom` varchar(20) DEFAULT NULL,
  `prenom` varchar(20) DEFAULT NULL,
  `login` varchar(40) NOT NULL,
  `mdp` varchar(200) DEFAULT NULL,
  `mail` varchar(50) DEFAULT NULL,
  `droits` int(11) NOT NULL,
  `accueil` int(11) NOT NULL,
  `droits_spe` varchar(200) DEFAULT NULL,
  `edt` int(11) DEFAULT NULL,
  `connected_info` int(11) DEFAULT NULL,
  `espace_default` int(11) DEFAULT NULL,
  `align_activ` varchar(10) DEFAULT NULL,
  `align_espace` varchar(10) DEFAULT NULL,
  `auth_mail` int(11) DEFAULT 0,
  `auth_chat` int(11) DEFAULT 0,
  `freq_res_dureemax` varchar(100) DEFAULT NULL,
  `sel` varchar(200) DEFAULT 'NULL',
  `lang` varchar(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_userconnect`
--

CREATE TABLE `preidlog_userconnect` (
  `user_id` int(11) DEFAULT NULL,
  `connected` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Structure de la table `preidlog_userevent`
--

CREATE TABLE `preidlog_userevent` (
  `user_id` int(11) NOT NULL,
  `uid` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Index pour les tables déchargées
--

--
-- Index pour la table `preidlog_agenda`
--
ALTER TABLE `preidlog_agenda`
  ADD PRIMARY KEY (`agenda_id`),
  ADD KEY `idx_creator` (`creator`);

--
-- Index pour la table `preidlog_barcodes`
--
ALTER TABLE `preidlog_barcodes`
  ADD PRIMARY KEY (`bcmodele_id`);

--
-- Index pour la table `preidlog_calendrier`
--
ALTER TABLE `preidlog_calendrier`
  ADD PRIMARY KEY (`date`);

--
-- Index pour la table `preidlog_edtbrik`
--
ALTER TABLE `preidlog_edtbrik`
  ADD PRIMARY KEY (`brik_id`),
  ADD KEY `idx_code_hor` (`code`),
  ADD KEY `idx_seqid` (`seq_id`);

--
-- Index pour la table `preidlog_edtcode`
--
ALTER TABLE `preidlog_edtcode`
  ADD PRIMARY KEY (`code_id`);

--
-- Index pour la table `preidlog_edtevent`
--
ALTER TABLE `preidlog_edtevent`
  ADD PRIMARY KEY (`uid`);

--
-- Index pour la table `preidlog_edtnivcolor`
--
ALTER TABLE `preidlog_edtnivcolor`
  ADD PRIMARY KEY (`id`);

--
-- Index pour la table `preidlog_eleves`
--
ALTER TABLE `preidlog_eleves`
  ADD PRIMARY KEY (`eleves_id`);

--
-- Index pour la table `preidlog_elevesmaj`
--
ALTER TABLE `preidlog_elevesmaj`
  ADD PRIMARY KEY (`eleves_id`);

--
-- Index pour la table `preidlog_espaces`
--
ALTER TABLE `preidlog_espaces`
  ADD PRIMARY KEY (`espace_id`);

--
-- Index pour la table `preidlog_etab`
--
ALTER TABLE `preidlog_etab`
  ADD PRIMARY KEY (`etab_id`);

--
-- Index pour la table `preidlog_exclucauses`
--
ALTER TABLE `preidlog_exclucauses`
  ADD PRIMARY KEY (`exclucause_id`);

--
-- Index pour la table `preidlog_exclusions`
--
ALTER TABLE `preidlog_exclusions`
  ADD PRIMARY KEY (`exclusion_id`);

--
-- Index pour la table `preidlog_freq`
--
ALTER TABLE `preidlog_freq`
  ADD PRIMARY KEY (`freq_id`),
  ADD KEY `idx_date_hor` (`date_freq`,`hor_name`),
  ADD KEY `idx_cas` (`cas`),
  ADD KEY `idx_eleve` (`eleves_id`),
  ADD KEY `idx_espace` (`espace_id`);

--
-- Index pour la table `preidlog_freqactiv`
--
ALTER TABLE `preidlog_freqactiv`
  ADD PRIMARY KEY (`activ_id`);

--
-- Index pour la table `preidlog_freqgrappes`
--
ALTER TABLE `preidlog_freqgrappes`
  ADD PRIMARY KEY (`freqgrap_id`);

--
-- Index pour la table `preidlog_freqres`
--
ALTER TABLE `preidlog_freqres`
  ADD PRIMARY KEY (`freqres_id`);

--
-- Index pour la table `preidlog_freqresref`
--
ALTER TABLE `preidlog_freqresref`
  ADD PRIMARY KEY (`refus_id`);

--
-- Index pour la table `preidlog_groupes`
--
ALTER TABLE `preidlog_groupes`
  ADD PRIMARY KEY (`groupe_id`);

--
-- Index pour la table `preidlog_horaires`
--
ALTER TABLE `preidlog_horaires`
  ADD PRIMARY KEY (`hor_id`),
  ADD UNIQUE KEY `hor_id` (`hor_id`),
  ADD UNIQUE KEY `hor_id_2` (`hor_id`);

--
-- Index pour la table `preidlog_hordemis`
--
ALTER TABLE `preidlog_hordemis`
  ADD PRIMARY KEY (`id`);

--
-- Index pour la table `preidlog_limits`
--
ALTER TABLE `preidlog_limits`
  ADD PRIMARY KEY (`limit_id`);

--
-- Index pour la table `preidlog_limitstxt`
--
ALTER TABLE `preidlog_limitstxt`
  ADD PRIMARY KEY (`limittxt_id`);

--
-- Index pour la table `preidlog_parametres`
--
ALTER TABLE `preidlog_parametres`
  ADD PRIMARY KEY (`param_id`);

--
-- Index pour la table `preidlog_periodes`
--
ALTER TABLE `preidlog_periodes`
  ADD PRIMARY KEY (`period_id`);

--
-- Index pour la table `preidlog_retards`
--
ALTER TABLE `preidlog_retards`
  ADD PRIMARY KEY (`retards_id`);

--
-- Index pour la table `preidlog_savchamps`
--
ALTER TABLE `preidlog_savchamps`
  ADD PRIMARY KEY (`sc_id`);

--
-- Index pour la table `preidlog_savele`
--
ALTER TABLE `preidlog_savele`
  ADD KEY `idx_eleve` (`eleves_id`),
  ADD KEY `idx_sid` (`s_id`);

--
-- Index pour la table `preidlog_savnotions`
--
ALTER TABLE `preidlog_savnotions`
  ADD PRIMARY KEY (`notion_id`);

--
-- Index pour la table `preidlog_savoirs1`
--
ALTER TABLE `preidlog_savoirs1`
  ADD PRIMARY KEY (`s1_id`);

--
-- Index pour la table `preidlog_savoirs2`
--
ALTER TABLE `preidlog_savoirs2`
  ADD PRIMARY KEY (`s2_id`);

--
-- Index pour la table `preidlog_savoirs3`
--
ALTER TABLE `preidlog_savoirs3`
  ADD PRIMARY KEY (`s3_id`);

--
-- Index pour la table `preidlog_savoirs4`
--
ALTER TABLE `preidlog_savoirs4`
  ADD PRIMARY KEY (`s4_id`);

--
-- Index pour la table `preidlog_savoirs5`
--
ALTER TABLE `preidlog_savoirs5`
  ADD PRIMARY KEY (`s5_id`);

--
-- Index pour la table `preidlog_savoirs6`
--
ALTER TABLE `preidlog_savoirs6`
  ADD PRIMARY KEY (`s6_id`);

--
-- Index pour la table `preidlog_savoirsmaj`
--
ALTER TABLE `preidlog_savoirsmaj`
  ADD PRIMARY KEY (`s_id`);

--
-- Index pour la table `preidlog_savoirst`
--
ALTER TABLE `preidlog_savoirst`
  ADD PRIMARY KEY (`st_id`);

--
-- Index pour la table `preidlog_seqdocs`
--
ALTER TABLE `preidlog_seqdocs`
  ADD PRIMARY KEY (`doc_id`);

--
-- Index pour la table `preidlog_sequences`
--
ALTER TABLE `preidlog_sequences`
  ADD PRIMARY KEY (`seq_id`);

--
-- Index pour la table `preidlog_sigbresas`
--
ALTER TABLE `preidlog_sigbresas`
  ADD PRIMARY KEY (`resas_id`);

--
-- Index pour la table `preidlog_tchat`
--
ALTER TABLE `preidlog_tchat`
  ADD PRIMARY KEY (`tchat_id`);

--
-- Index pour la table `preidlog_user`
--
ALTER TABLE `preidlog_user`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `login` (`login`);

--
-- AUTO_INCREMENT pour les tables déchargées
--

--
-- AUTO_INCREMENT pour la table `preidlog_agenda`
--
ALTER TABLE `preidlog_agenda`
  MODIFY `agenda_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_barcodes`
--
ALTER TABLE `preidlog_barcodes`
  MODIFY `bcmodele_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_edtbrik`
--
ALTER TABLE `preidlog_edtbrik`
  MODIFY `brik_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_edtcode`
--
ALTER TABLE `preidlog_edtcode`
  MODIFY `code_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_edtevent`
--
ALTER TABLE `preidlog_edtevent`
  MODIFY `uid` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_edtnivcolor`
--
ALTER TABLE `preidlog_edtnivcolor`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_eleves`
--
ALTER TABLE `preidlog_eleves`
  MODIFY `eleves_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_elevesmaj`
--
ALTER TABLE `preidlog_elevesmaj`
  MODIFY `eleves_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_espaces`
--
ALTER TABLE `preidlog_espaces`
  MODIFY `espace_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_etab`
--
ALTER TABLE `preidlog_etab`
  MODIFY `etab_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_exclucauses`
--
ALTER TABLE `preidlog_exclucauses`
  MODIFY `exclucause_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_exclusions`
--
ALTER TABLE `preidlog_exclusions`
  MODIFY `exclusion_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_freq`
--
ALTER TABLE `preidlog_freq`
  MODIFY `freq_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_freqactiv`
--
ALTER TABLE `preidlog_freqactiv`
  MODIFY `activ_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_freqgrappes`
--
ALTER TABLE `preidlog_freqgrappes`
  MODIFY `freqgrap_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_freqres`
--
ALTER TABLE `preidlog_freqres`
  MODIFY `freqres_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_freqresref`
--
ALTER TABLE `preidlog_freqresref`
  MODIFY `refus_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_groupes`
--
ALTER TABLE `preidlog_groupes`
  MODIFY `groupe_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_horaires`
--
ALTER TABLE `preidlog_horaires`
  MODIFY `hor_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_limits`
--
ALTER TABLE `preidlog_limits`
  MODIFY `limit_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_limitstxt`
--
ALTER TABLE `preidlog_limitstxt`
  MODIFY `limittxt_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_parametres`
--
ALTER TABLE `preidlog_parametres`
  MODIFY `param_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_periodes`
--
ALTER TABLE `preidlog_periodes`
  MODIFY `period_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_retards`
--
ALTER TABLE `preidlog_retards`
  MODIFY `retards_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_savchamps`
--
ALTER TABLE `preidlog_savchamps`
  MODIFY `sc_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_savnotions`
--
ALTER TABLE `preidlog_savnotions`
  MODIFY `notion_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_seqdocs`
--
ALTER TABLE `preidlog_seqdocs`
  MODIFY `doc_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_sequences`
--
ALTER TABLE `preidlog_sequences`
  MODIFY `seq_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_sigbresas`
--
ALTER TABLE `preidlog_sigbresas`
  MODIFY `resas_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_tchat`
--
ALTER TABLE `preidlog_tchat`
  MODIFY `tchat_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT pour la table `preidlog_user`
--
ALTER TABLE `preidlog_user`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;