<?php
ob_start(); // démarre un buffer de sortie

// Fonction pour nettoyer le BOM et caractères invisibles
function clean_output($buffer) {
    // Supprime BOM UTF-8
    $buffer = preg_replace('/^\x{FEFF}/u', '', $buffer);
    // Supprime tous les caractères invisibles en début de fichier
    $buffer = @ltrim($buffer, "\x00..\x1F");
    return $buffer;
}

register_shutdown_function(function() {
    $contents = ob_get_clean();
    echo clean_output($contents);
});
$_SESSION['etabchoix']=@$_COOKIE['LOGGED_ETAB']; 
require_once(dirname(__DIR__, 1) . '/config.php');
require_once(BASE_PATH . '/db/idl_connect.php');
function normalize($str) {
    $unwanted_array = [
        'À'=>'A','Á'=>'A','Â'=>'A','Ã'=>'A','Ä'=>'A','Å'=>'A','Æ'=>'AE','Ç'=>'C','È'=>'E','É'=>'E',
        'Ê'=>'E','Ë'=>'E','Ì'=>'I','Í'=>'I','Î'=>'I','Ï'=>'I','Ð'=>'D','Ñ'=>'N','Ò'=>'O','Ó'=>'O',
        'Ô'=>'O','Õ'=>'O','Ö'=>'O','Ù'=>'U','Ú'=>'U','Û'=>'U','Ü'=>'U','Ý'=>'Y','Þ'=>'TH','ß'=>'ss',
        'à'=>'a','á'=>'a','â'=>'a','ã'=>'a','ä'=>'a','å'=>'a','æ'=>'ae','ç'=>'c','è'=>'e','é'=>'e',
        'ê'=>'e','ë'=>'e','ì'=>'i','í'=>'i','î'=>'i','ï'=>'i','ð'=>'d','ñ'=>'n','ò'=>'o','ó'=>'o',
        'ô'=>'o','õ'=>'o','ö'=>'o','ù'=>'u','ú'=>'u','û'=>'u','ü'=>'u','ý'=>'y','þ'=>'th','ÿ'=>'y'
    ];
    $str = strtr($str, $unwanted_array);
    return mb_strtolower($str, 'UTF-8');
}

$suggestions = [];
if (isset($_GET['term'])) {
    $term = $_GET['term'];
    $term_norm = normalize($term);

    // on récupère tous les élèves (ou limite selon besoins)
    $query = "SELECT nom, prenom, division 
              FROM ".$prefix."_eleves 
              ORDER BY nom, prenom ASC";
    $result = mysqli_query($bdd, $query);

    while ($row = mysqli_fetch_assoc($result)) {
        $nom = $row['nom'];
        $prenom = $row['prenom'];
        $division = $row['division'];

        // normalisation pour la comparaison
        $nom_norm = normalize($nom);

        // commence par le terme recherché ?
        if (strpos($nom_norm, $term_norm) === 0) {
            $eleve = $nom . ', ' . $prenom . ' (' . $division . ')';
            $suggestions[] = [
                'label' => $eleve,
                'value' => $eleve
            ];
        }
    }

    $json = json_encode($suggestions, JSON_UNESCAPED_UNICODE);
    $json = preg_replace('/^\x{FEFF}/u', '', $json);

    // Renvoi JSON pur (même en mode debug)
    echo $json;
    exit;
}
?>