<?php
/* Extensions autorisées pour les séquences */
$extensions = array("JPG", "JPEG", "WEBP", "BMP", "JFIF", "PNG", "GIF", "SVG", "TXT", "ODT", "ODS", "ODP", "PDF", "PPT", "PPTX", "DOC", "DOCX", "CSV", "XLS", "XLSX", "ZIP", "7Z");

// Tableau associatif pour convertir les jours de la semaine en nombres de jours
$daysOfWeek = array(
    'mon' => 1,
    'tue' => 2,
    'wed' => 3,
    'thu' => 4,
    'fri' => 5,
    'sat' => 6,
    'sun' => 7
);

$etab_lieu = false;

try {
    $etab_lieu = @mysqli_query($bdd, "SELECT * FROM {$prefix}_etab ORDER BY etab_id DESC LIMIT 1");
} catch (mysqli_sql_exception $e) {
    // On ignore l'erreur pour laisser le else faire son travail
    error_log("Table etab manquante ou erreur SQL : " . $e->getMessage());
}

if ($etab_lieu && mysqli_num_rows($etab_lieu) > 0) {
    $etab_i = mysqli_fetch_array($etab_lieu);
    $_SESSION['lieu_nom'] = !empty($etab_i['lieu_nom']) ? $etab_i['lieu_nom'] : 'CDI';

    // Vérification de lieu_genre et de la clé dans le tableau GENRES
    if (!empty($etab_i['lieu_genre']) && isset(GENRES[$etab_i['lieu_genre']])) {
        $genexp = explode(";", GENRES[$etab_i['lieu_genre']]);
        $_SESSION['lieu_genre1'] = $genexp[0];
        $_SESSION['lieu_genre2'] = $genexp[1];
    } else {
        // Valeurs par défaut si lieu_genre est vide ou non défini dans GENRES
        $_SESSION['lieu_genre1'] = 'du';
        $_SESSION['lieu_genre2'] = 'au';
    }
} else {
    $_SESSION['lieu_nom'] = 'CDI';
    $_SESSION['lieu_genre1'] = 'du';
    $_SESSION['lieu_genre2'] = 'au';
}
function replacePlaceholdersToDb($text) {
    $mapping = array_flip(BARCODELEMS); // Inverser les clés et valeurs
    return strtr($text, $mapping);
}
function replacePlaceholdersFromDb($text) {
    return strtr($text, BARCODELEMS);
}

?>