<?php

echo '<p><b>Mise à jour de la base de données <i class="fas fa-angle-double-right"></i> Version 0.57</b></p>
<ul class="maxwidth">';

function create_index_if_not_exists($bdd, $table, $index_name, $index_columns) {
   $query = "SELECT COUNT(1) 
              FROM information_schema.STATISTICS 
              WHERE TABLE_SCHEMA = DATABASE() 
              AND TABLE_NAME = ? 
              AND INDEX_NAME = ?";
    $stmt = mysqli_prepare($bdd, $query);
    mysqli_stmt_bind_param($stmt, 'ss', $table, $index_name);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $exists = mysqli_fetch_array($result)[0];

    if ($exists == 0) {
        $create_query = "CREATE INDEX $index_name ON $table ($index_columns)";
        mysqli_query($bdd, $create_query);
        echo "<li>Index $index_name créé sur $table ($index_columns).</li>";
    } else {
        echo "<li>Index $index_name existe déjà sur $table.</li>";
    }
}

create_index_if_not_exists($bdd, $prefix."_freq", "idx_date_hor", "date_freq, hor_name");
create_index_if_not_exists($bdd, $prefix."_freq", "idx_cas", "cas");
create_index_if_not_exists($bdd, $prefix."_freq", "idx_eleve", "eleves_id");
create_index_if_not_exists($bdd, $prefix."_freq", "idx_espace", "espace_id");

create_index_if_not_exists($bdd, $prefix."_edtbrik", "idx_code_hor", "code");
create_index_if_not_exists($bdd, $prefix."_edtbrik", "idx_seqid", "seq_id");
create_index_if_not_exists($bdd, $prefix."_edtbrik", "idx_div", "division");

create_index_if_not_exists($bdd, $prefix."_savele", "idx_eleve", "eleves_id");
create_index_if_not_exists($bdd, $prefix."_savele", "idx_sid", "s_id");

// Correction du paramétrage par défaut du modèle de code-barre (si nécessaire).
$bc_test = mysqli_fetch_assoc(mysqli_query($bdd,"SELECT * FROM ".$prefix."_parametres WHERE param_nom = 'barcodes_default_modeleve'"));
if($bc_test['valeur']=='default') {
	mysqli_query($bdd,"UPDATE ".$prefix."_parametres SET valeur = '1' WHERE param_nom = 'barcodes_default_modeleve'");
}
echo '<li>Correction du paramétrage par défaut du modèle de code-barre (si nécessaire).</li>';

// Maximum applicable quel que soit l\'origine de l\'inscription (seul l\'élève par défaut).
if(mysqli_num_rows(mysqli_query($bdd,"SELECT * FROM ".$prefix."_parametres WHERE param_nom = 'freqres_max_origin'"))==0) {
    mysqli_query($bdd,"INSERT INTO ".$prefix."_parametres (param_id, param_nom, valeur, comments) VALUES ('', 'freqres_max_origin', '0', 'Maximum applicable quel que soit l\'origine de l\'inscription.')");
}
echo '<li>Maximum applicable quel que soit l\'origine de l\'inscription (seul l\'élève par défaut).</li>';

// Possibilité d'opérer en préalable toutes les inscriptions des réservations de la journée.
if(mysqli_num_rows(mysqli_query($bdd,"SELECT * FROM ".$prefix."_parametres WHERE param_nom = 'freqres_inscriptallday'"))==0) {
    mysqli_query($bdd,"INSERT INTO ".$prefix."_parametres (param_id, param_nom, valeur, comments) VALUES ('', 'freqres_inscriptallday', '0', 'Possibilité d\'opérer en préalable toutes les inscriptions des réservations de la journée.')");
}
echo '<li>Possibilité d\'opérer en préalable toutes les inscriptions des réservations de la journée (désactivée par défaut).</li>';

// version bdd :
mysqli_query($bdd,"UPDATE ".$prefix."_parametres SET valeur = '0.57' WHERE param_nom = 'version_bdd'");
echo '<li>Mise à jour de la base de données effectuée - version_bdd 0.57.</li></ul>';
?>