<?php

echo '<p><b>Mise à jour base de données <i class="fas fa-angle-double-right"></i> Version 0.36</b></p>
<ul class="maxwidth">';

// Ajout d'une colonne close dans la table _edtbrik
mysqli_query($bdd,"ALTER TABLE ".$prefix."_edtbrik ADD close INT ( 11 ) DEFAULT NULL");
echo '<li>Ajout d\'une colonne <i>close</i> dans la table _edtbrik.</li>';

// Alimentation de la colonne close dans _edtbrik
mysqli_query($bdd,"UPDATE ".$prefix."_edtbrik SET close = '1' WHERE code = 'CLOSE'");
mysqli_query($bdd,"UPDATE ".$prefix."_edtbrik SET close = '0' WHERE code <> 'CLOSE'");
echo '<li>Alimentation de la colonne <i>close</i> selon ouverture ou fermeture.</li>';

// Suppression du code CLOSE dans _edtbrik > code
mysqli_query($bdd,"UPDATE ".$prefix."_edtbrik SET code = '' WHERE code = 'CLOSE'");
echo '<li>Suppression du code CLOSE dans les codes de la table _edtbrik</li>';

// Ajout d'une seance dans la table _edtbrik
mysqli_query($bdd,"ALTER TABLE ".$prefix."_edtbrik ADD seance INT ( 11 ) DEFAULT NULL");
echo '<li>Ajout d\'une colonne <i>seance</i> dans la table _edtbrik.</li>';

// Alimentation de la colonne seance dans _edtbrik
mysqli_query($bdd,"UPDATE ".$prefix."_edtbrik SET seance = '1' WHERE textelibre = ''");
mysqli_query($bdd,"UPDATE ".$prefix."_edtbrik SET seance = '0' WHERE textelibre <> ''");
echo '<li>Alimentation de la colonne <i>seance</i> selon séquences et codages pédagogiques.</li>';

// Ajout d'une colonne hor_name dans la table _edtevent
mysqli_query($bdd,"ALTER TABLE ".$prefix."_edtevent ADD hor_name VARCHAR ( 2 ) COLLATE utf8_unicode_ci DEFAULT NULL");
echo '<li>Ajout d\'une colonne <i>hor_name</i> dans la table _edtevent.</li>';

// Alimentation de la colonne hor_name dans _edtevent
$check_hors = mysqli_query($bdd,"SELECT * FROM ".$prefix."_horaires");
foreach($check_hors as $check_hor) {
	mysqli_query($bdd,"UPDATE ".$prefix."_edtevent SET hor_name = '".$check_hor['hor_name']."' WHERE hor_id = '".$check_hor['hor_id']."'");
}
echo '<li>Alimentation de la colonne <i>hor_name</i> selon la table des horaires.</li>';

// Ajout d'une colonne specifique dans la table _edtevent
mysqli_query($bdd,"ALTER TABLE ".$prefix."_edtevent ADD specifique INT ( 11 ) DEFAULT '0'");
echo '<li>Ajout d\'une colonne <i>specifique</i> dans la table _edtevent.</li>';

// Ajout d'une colonne duration pour gérer les horaires spécifiques
mysqli_query($bdd,"ALTER TABLE ".$prefix."_edtevent ADD duration INT ( 11 ) DEFAULT '10'");
echo '<li>Ajout d\'une colonne <i>duration</i> dans la table _edtevent (pour gérer la durée des créneaux spécifiques dans les statistiques).</li>';

// Ajout d'une colonne mdp dans la table _elevesmaj
mysqli_query($bdd,"ALTER TABLE ".$prefix."_elevesmaj ADD mdp VARCHAR ( 200 ) COLLATE utf8_unicode_ci DEFAULT NULL");
echo '<li>Ajout d\'une colonne <i>mdp</i> dans la table _elevesmaj.</li>';

// Ajout d'une colonne mdp dans la table _eleves
mysqli_query($bdd,"ALTER TABLE ".$prefix."_eleves ADD mdp VARCHAR ( 200 ) COLLATE utf8_unicode_ci DEFAULT NULL");
echo '<li>Ajout d\'une colonne <i>mdp</i> dans la table _eleves.</li>';

// Alimentation des mdp dans la table _eleves
$check_eleves = mysqli_query($bdd,"SELECT * FROM ".$prefix."_eleves");
foreach($check_eleves as $check_eleve) {
	mysqli_query($bdd,"UPDATE ".$prefix."_eleves SET mdp = PASSWORD('".mb_strtolower(substr($check_eleve['prenom'],0,1),'UTF-8').substr($check_eleve['naissance'],8,2).substr($check_eleve['naissance'],5,2).substr($check_eleve['naissance'],0,4)."') WHERE eleves_id = '".$check_eleve['eleves_id']."'");
}
echo '<li>Alimentation de la colonne <i>mdp</i> dans la table _eleves.</li>';

// Contenu de la table _edtcode`
if(mysqli_num_rows(mysqli_query($bdd,"SELECT * FROM ".$prefix."_edtcode"))==0) {
	$edtcode_insert = "INSERT INTO ".$prefix."_edtcode (code_id, code, nom, activ_code, default_code, bgcolor_code) VALUES
	(1, 'Info-Doc', 'Information-documentation', 1, 1, '#FF9900'),
	(2, 'EMI', 'Education aux médias et à l''information', 1, 0, '#99FF00'),
	(3, 'IRD', 'Initiation à la recherche documentaire', 1, 0, '#CCFFFF'),
	(4, 'EAM', 'Education aux médias', 1, 0, '#FF66FF'),
	(5, 'EMC', 'Enseignement moral et civique', 1, 0, '#CC6600'),
	(6, 'Hist-Géo', 'Histoire-Géographie', 1, 0, '#FFFF33'),
	(7, 'Techno', 'Technologie', 1, 0, '#99CC66'),
	(8, 'SVT', 'Science de la vie et de la terre', 1, 0, '#1E7FCB'),
	(9, 'P-C', 'Physique-Chimie', 1, 0, '#9900FF'),
	(10, 'Fr.', 'Français', 1, 0, '#FF0033'),
	(11, 'LVE', 'Langues vivantes étrangères', 1, 0, '#CCCC00'),
	(12, 'Maths', 'Mathématiques', 1, 0, '#66CC66'),
	(13, 'HDA', 'Histoire des Arts', 1, 0, '#EFD242'),
	(14, 'Arts pla.', 'Arts plastiques', 1, 0, '#FFF48D'),
	(15, 'AP', 'Accompagnement personnalisé', 1, 0, '#CC99CC'),
	(16, 'EPI', 'Enseignement pratique interdisciplinaire', 1, 0, '#E6E697'), 
	(17, 'Avenir', 'Parcours Avenir', 1, 0, '#FF6666'),
	(18, 'Santé', 'Parcours Santé', 1, 0, '#F4C430')";
	mysqli_query($bdd,$edtcode_insert);
}

// suppression du paramétrage de feuille de style :
mysqli_query($bdd,"DELETE FROM ".$prefix."_parametres WHERE param_nom = 'style_css'");
echo '<li>Suppression du paramétrage de feuille de style.</li>';

// Suppression des fichiers obsolètes concernant les feuilles de style
$ouverture = opendir("./css/");
$lecture = readdir($ouverture);
$filename = './css/css.php';
if (file_exists($filename)) {
	unlink ("./css/css.php");
}
$filename = './css/idl_classic.css';
if (file_exists($filename)) {
	unlink ("./css/idl_classic.css");
}
$filename = './css/idl_classic_print.css';
if (file_exists($filename)) {
	unlink ("./css/idl_classic_print.css");
}
closedir($ouverture);
echo '<li>Suppression des fichiers obsolètes concernant les feuilles de style</li>';

// Ajout d'un quota d'inscription dans la table _horaires
mysqli_query($bdd,"ALTER TABLE ".$prefix."_horaires ADD quota_freq INT ( 11 ) DEFAULT '0'");
echo '<li>Ajout d\'une colonne <i>quota_freq</i> dans la table _horaires (pour des quotas spécifiques par créneau).</li>';

// Ajout d'un droit resa dans la table _horaires
mysqli_query($bdd,"ALTER TABLE ".$prefix."_horaires ADD hor_resa INT ( 11 ) DEFAULT NULL");
echo '<li>Ajout d\'une colonne <i>hor_resa</i> dans la table _horaires (pour le choix des créneaux avec réservations).</li>';

// Alimentation des hor_resa dans la table _horaires
$check_hors = mysqli_query($bdd,"SELECT * FROM ".$prefix."_horaires");
foreach($check_hors as $check_hor) {
	if($check_hor['hor_freq']==1) { $hor_resa = 1; } else { $hor_resa = 0; }
	mysqli_query($bdd,"UPDATE ".$prefix."_horaires SET hor_resa = '".$hor_resa."' WHERE hor_id = '".$check_hor['hor_id']."'");
}
echo '<li>Alimentation de la colonne <i>hor_resa</i> dans la table _horaires (réservation possible par défaut quand l\'inscription est déjà possible).</li>';

// Ajout d'un quota de réservation dans la table _horaires
mysqli_query($bdd,"ALTER TABLE ".$prefix."_horaires ADD quota_resa INT ( 11 ) DEFAULT '0'");
echo '<li>Ajout d\'une colonne <i>quota_resa</i> dans la table _horaires (pour des quotas spécifiques par créneau pour les réservations).</li>';

// version bdd :
mysqli_query($bdd,"UPDATE ".$prefix."_parametres SET valeur = '0.36' WHERE param_nom = 'version_bdd'");
echo '<li>Mise à jour de la base de données effectuée - version_bdd 0.36.</li></ul>';
?>