<?php
session_start();
include('../../config.php');
require_once(BASE_PATH . '/db/idl_connect.php');

if (!isset($_SESSION['login'])) {
    die("Non autorisé.");
}

$sender = $_SESSION['user_id'];
$receiver = $_POST['receiver'];
$message = $_POST['message'];

$sql = "INSERT INTO {$prefix}_tchat 
    (sender_id, receiver_id, message, created_at, is_read) 
    VALUES (?, ?, ?, NOW(), 0)";

if ($bdd instanceof PDO) {
    // Cas PDO
    $query = $bdd->prepare($sql);
    $success = $query->execute([$sender, $receiver, $message]);

} elseif ($bdd instanceof mysqli) {
    // Cas MySQLi
    $query = $bdd->prepare($sql);
    if ($query === false) {
        die("Erreur de préparation : " . $bdd->error);
    }

    // Adapter le type de chaque variable selon vos besoins
    $query->bind_param("iis", $sender, $receiver, $message); 
    $success = $query->execute();

}

echo "Message envoyé.";
?>