<?php
session_start();
include("../../config.php"); // Inclure la connexion à la base de données
require_once(BASE_PATH . '/db/idl_connect.php');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(["success" => false, "error" => "Non connecté"]);
    exit;
}

if (isset($_POST['message_id'])) {
    $messageId = intval($_POST['message_id']);
    $userId = $_SESSION['user_id'];

    // Vérifier que l'utilisateur est bien le propriétaire du message
    $query = "DELETE FROM ".$prefix."_tchat WHERE tchat_id = ? AND sender_id = ?";
    $stmt = $bdd->prepare($query);
    $stmt->bind_param("ii", $messageId, $userId);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        echo json_encode(["success" => true]);
    } else {
        echo json_encode(["success" => false, "error" => "Action non autorisée"]);
    }

    $stmt->close();
} else {
    echo json_encode(["success" => false, "error" => "Données invalides"]);
}
?>