<?php
// Liste d'encodages pertinents et fiables
$enclist = ['UTF-8', 'Windows-1252', 'ISO-8859-1', 'ISO-8859-15', 'ASCII'];

// Lecture brute du fichier
$content = file_get_contents($_FILES['file']['tmp_name']);

// Détection de l'encodage
$encodage = mb_detect_encoding($content, $enclist, true);

if ($encodage === false) {
    echo '<p class="signal">' . PBFILE1 . '</p>';
    exit;
}

// Convertir en UTF-8 si nécessaire
if ($encodage !== 'UTF-8') {
    $content = mb_convert_encoding($content, 'UTF-8', $encodage);
}

echo '<h1>' . ELEVINSTALL . '</h1>';
$id = 1;

// Chargement du XML
libxml_use_internal_errors(true);

if (!$xmlEleves) {
    echo '<p class="signal">Erreur de lecture du fichier XML.</p>';
    foreach (libxml_get_errors() as $error) {
        echo "<p class='signal'>Erreur XML : " . htmlspecialchars($error->message) . "</p>";
    }
    libxml_clear_errors();
    exit;
}

// Extraction des structures
$eleves = isset($xmlEleves->DONNEES) ? $xmlEleves->DONNEES->ELEVES : $xmlEleves->ELEVES;
$structures = [];

foreach ($xmlEleves->DONNEES->STRUCTURES->STRUCTURES_ELEVE as $structure_eleve) {
    $eleve_strucid = (string) $structure_eleve['ELEVE_ID'];
    $code_structure = isset($structure_eleve->STRUCTURE->CODE_STRUCTURE) 
        ? mysqli_real_escape_string($bdd, (string)$structure_eleve->STRUCTURE->CODE_STRUCTURE) 
        : null;
    $structures[$eleve_strucid] = $code_structure;
}

if ($xmlResponsables) {
    $personnes = [];
    if (isset($xmlResponsables->DONNEES->PERSONNES->PERSONNE)) {
        foreach ($xmlResponsables->DONNEES->PERSONNES->PERSONNE as $personne) {
            // Ici PERSONNE_ID est un attribut
            $pid = trim((string) $personne['PERSONNE_ID']);
            if ($pid === '') continue;

            $personnes[$pid] = [
                'nom'        => trim((string) $personne->NOM_DE_FAMILLE),
                'prenom'     => trim((string) $personne->PRENOM),
                'adresse_id' => trim((string) $personne->ADRESSE_ID)
            ];
        }
    }

    $adresses = [];
    if (isset($xmlResponsables->DONNEES->ADRESSES->ADRESSE)) {
        foreach ($xmlResponsables->DONNEES->ADRESSES->ADRESSE as $adresse) {
            $aid = trim((string) $adresse['ADRESSE_ID']); // attribut
            if ($aid === '') continue;

            $adresses[$aid] = [
                'add1'    => trim((string) $adresse->LIGNE3_ADRESSE),
                'add2'    => trim((string) $adresse->LIGNE4_ADRESSE),
                'cpostal' => trim((string) $adresse->CODE_POSTAL),
                'ville'   => trim((string) $adresse->LIBELLE_POSTAL)
            ];
        }
    }

    $responsables = [];
    if (isset($xmlResponsables->DONNEES->RESPONSABLES->RESPONSABLE_ELEVE)) {
        foreach ($xmlResponsables->DONNEES->RESPONSABLES->RESPONSABLE_ELEVE as $resp) {
            $eid = trim((string) $resp->ELEVE_ID);      // Élément enfant
            $pid = trim((string) $resp->PERSONNE_ID);   // Élément enfant

            if ($eid === '' || $pid === '') continue;

            if ((string)$resp->NIVEAU_RESPONSABILITE === "1") {
                $responsables[$eid] = $pid;
            }
        }
    }
}

// Traitement des élèves
foreach ($eleves->ELEVE as $eleve) {
    include('database_datainput_check_xml.php');

    // Sécuriser les variables manquantes
    $att_code = isset($att_code) ? $att_code : '';
    $att_ident = isset($att_ident) ? $att_ident : '';
    $att_mdp = isset($att_mdp) ? $att_mdp : '';
    $att_mail = isset($att_mail) ? $att_mail : '';
    $att_resp_nom = isset($att_resp_nom) ? $att_resp_nom : '';
    $att_add1 = isset($att_add1) ? $att_add1 : '';
    $att_add2 = isset($att_add2) ? $att_add2 : '';
    $att_cpostal = isset($att_cpostal) ? $att_cpostal : '';
    $att_ville = isset($att_ville) ? $att_ville : '';
    
    $eleve_id = (string) $eleve['ELEVE_ID'];
    $nom = mysqli_real_escape_string($bdd, (string) $eleve->NOM_DE_FAMILLE);
    $prenom = mysqli_real_escape_string($bdd, (string) $eleve->PRENOM);

    $div = $structures[$eleve_id] ?? null;
    if ($div === null && isset($eleve->CODE_STRUCTURE)) {
        $div = mysqli_real_escape_string($bdd, (string) $eleve->CODE_STRUCTURE);
    }

    // Unicité
    if (mysqli_num_rows(mysqli_query($bdd, "SELECT * FROM ".$prefix."_user WHERE login = '$att_code'")) > 0 || $att_code === 'reserver') {
        $att_code = '';
    }
    if (mysqli_num_rows(mysqli_query($bdd, "SELECT * FROM ".$prefix."_user WHERE login = '$att_ident'")) > 0 || $att_ident === 'reserver') {
        $att_ident = '';
    }

    $att_resp_nom = '';
    $att_add1 = '';
    $att_add2 = '';
    $att_cpostal = '';
    $att_ville = '';
    if (!empty($_POST['input_adresse_xml'])) {
        $pid = $responsables[$eleve_id];
        if (isset($personnes[$pid])) {
            $nom_resp    = $personnes[$pid]['nom'];
            $prenom_resp = $personnes[$pid]['prenom'];

            if ($nom_resp || $prenom_resp) {
                $att_resp_nom = mysqli_real_escape_string($bdd, trim($nom_resp.' '.$prenom_resp));
            }

            $aid = $personnes[$pid]['adresse_id'] ?? null;
            if ($aid && isset($adresses[$aid])) {
                $att_add1    = $adresses[$aid]['add1']    !== '' ? mysqli_real_escape_string($bdd, $adresses[$aid]['add1'])    : null;
                $att_add2    = $adresses[$aid]['add2']    !== '' ? mysqli_real_escape_string($bdd, $adresses[$aid]['add2'])    : null;
                $att_cpostal = $adresses[$aid]['cpostal'] !== '' ? mysqli_real_escape_string($bdd, $adresses[$aid]['cpostal']) : null;
                $att_ville   = $adresses[$aid]['ville']   !== '' ? mysqli_real_escape_string($bdd, $adresses[$aid]['ville'])   : null;
            }
        }
    }
    
    // Date de naissance
    $naiss = (string) $eleve->DATE_NAISS;
    $jour = substr($naiss, 0, 2);
    $mois = substr($naiss, 3, 2);
    $annee = substr($naiss, 6, 4);

    // Sexe
    $sexe = (string) $eleve->CODE_SEXE;
    $sexe = $sexe === '2' ? 'F' : ($sexe === '1' ? 'M' : '');

    if (!isset($att_mail)) { $att_mail = ""; }
    if (empty($att_mdp)) {
        $att_mdp = mb_strtolower(substr(strToNoAccent($prenom), 0, 1), 'UTF-8') . $jour . $mois . $annee;
    }

    do {
        $sel = bin2hex(random_bytes(16));
    } while ($sel === '0');

    $hashed_password = hash('sha256', $att_mdp . $sel);

    // Insertion dans la base
    if ($div !== null) {
         $query = "INSERT INTO ".$prefix."_elevesmaj (eleves_id, nom, prenom, division, naissance, sexe, code, mdp, sel, mail, id_perso, resp_nom, add1, add2, cpostal, ville, categ)
                  VALUES ('$id', '$nom', '$prenom', '$div', '$annee-$mois-$jour', '$sexe', '$att_code', '$hashed_password', '$sel', '$att_mail', '$att_ident', '$att_resp_nom', '$att_add1', '$att_add2', '$att_cpostal', '$att_ville', '1')";
        mysqli_query($bdd, $query);
        $id++;
    }
}
?>